/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.HostModule;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.HostedRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Candidates {
    private final Module m_root;
    private final Map<Capability, Set<Requirement>> m_dependentMap;
    private final Map<Requirement, SortedSet<Capability>> m_candidateMap;
    private final Map<Capability, Map<String, Map<Version, List<Requirement>>>> m_hostFragments;
    private final Map<Module, HostModule> m_allWrappedHosts;
    private final Map<Module, Object> m_populateResultCache;

    private Candidates(Module root, Map<Capability, Set<Requirement>> dependentMap, Map<Requirement, SortedSet<Capability>> candidateMap, Map<Capability, Map<String, Map<Version, List<Requirement>>>> hostFragments, Map<Module, HostModule> wrappedHosts, Map<Module, Object> populateResultCache) {
        this.m_root = root;
        this.m_dependentMap = dependentMap;
        this.m_candidateMap = candidateMap;
        this.m_hostFragments = hostFragments;
        this.m_allWrappedHosts = wrappedHosts;
        this.m_populateResultCache = populateResultCache;
    }

    public Candidates(Resolver.ResolverState state, Module root) {
        this.m_root = root;
        this.m_dependentMap = new HashMap<Capability, Set<Requirement>>();
        this.m_candidateMap = new HashMap<Requirement, SortedSet<Capability>>();
        this.m_hostFragments = new HashMap<Capability, Map<String, Map<Version, List<Requirement>>>>();
        this.m_allWrappedHosts = new HashMap<Module, HostModule>();
        this.m_populateResultCache = new HashMap<Module, Object>();
        this.populate(state, this.m_root);
    }

    public Candidates(Resolver.ResolverState state, Module root, Requirement req, SortedSet<Capability> candidates) {
        this.m_root = root;
        this.m_dependentMap = new HashMap<Capability, Set<Requirement>>();
        this.m_candidateMap = new HashMap<Requirement, SortedSet<Capability>>();
        this.m_hostFragments = new HashMap<Capability, Map<String, Map<Version, List<Requirement>>>>();
        this.m_allWrappedHosts = new HashMap<Module, HostModule>();
        this.m_populateResultCache = new HashMap<Module, Object>();
        this.add(req, candidates);
        this.populateDynamic(state, this.m_root);
    }

    public final void populate(Resolver.ResolverState state, Module module) {
        Integer cycleCount = null;
        Map<Requirement, SortedSet<Capability>> localCandidateMap = null;
        List<Requirement> remainingReqs = null;
        Object[] cacheValue = this.m_populateResultCache.get(module);
        if (cacheValue instanceof ResolveException) {
            throw (ResolveException)cacheValue;
        }
        if (cacheValue instanceof Boolean) {
            return;
        }
        if (cacheValue != null) {
            Integer n = new Integer((Integer)((Object[])cacheValue)[0] + 1);
            ((Object[])cacheValue)[0] = n;
            cycleCount = n;
            localCandidateMap = (Map)((Object[])cacheValue)[1];
            remainingReqs = (List)((Object[])cacheValue)[2];
        }
        if (remainingReqs == null && localCandidateMap == null) {
            state.checkExecutionEnvironment(module);
            state.checkNativeLibraries(module);
            cycleCount = new Integer(0);
            localCandidateMap = new HashMap<Requirement, SortedSet<Capability>>();
            remainingReqs = new ArrayList<Requirement>(module.getRequirements());
            cacheValue = new Object[]{cycleCount, localCandidateMap, remainingReqs};
            this.m_populateResultCache.put(module, cacheValue);
        }
        while (remainingReqs.size() > 0) {
            Requirement req = (Requirement)remainingReqs.remove(0);
            ResolveException rethrow = null;
            SortedSet<Capability> candidates = state.getCandidates(module, req, true);
            Iterator itCandCap = candidates.iterator();
            while (itCandCap.hasNext()) {
                Capability candCap = (Capability)itCandCap.next();
                if (!Util.isFragment(candCap.getModule()) && (candCap.getModule().isResolved() || candCap.getModule().equals(module))) continue;
                try {
                    this.populate(state, candCap.getModule());
                }
                catch (ResolveException ex) {
                    if (rethrow == null) {
                        rethrow = ex;
                    }
                    itCandCap.remove();
                }
            }
            if (candidates.isEmpty() && !req.isOptional()) {
                String msg = new StringBuffer().append("Unable to resolve ").append(module).append(": missing requirement ").append(req).toString();
                if (rethrow != null) {
                    msg = new StringBuffer().append(msg).append(" [caused by: ").append(rethrow.getMessage()).append("]").toString();
                }
                rethrow = new ResolveException(msg, module, req);
                this.m_populateResultCache.put(module, rethrow);
                throw rethrow;
            }
            if (candidates.size() <= 0) continue;
            localCandidateMap.put(req, candidates);
        }
        if (cycleCount > 0) {
            ((Object[])cacheValue)[0] = new Integer(cycleCount - 1);
        } else if (cycleCount == 0) {
            this.m_populateResultCache.put(module, Boolean.TRUE);
            if (localCandidateMap.size() > 0) {
                this.add(localCandidateMap);
            }
        }
    }

    private void populateDynamic(Resolver.ResolverState state, Module module) {
        ResolveException rethrow = null;
        Map.Entry<Requirement, SortedSet<Capability>> entry = this.m_candidateMap.entrySet().iterator().next();
        Requirement dynReq = entry.getKey();
        SortedSet<Capability> candidates = entry.getValue();
        Iterator itCandCap = candidates.iterator();
        while (itCandCap.hasNext()) {
            Capability candCap = (Capability)itCandCap.next();
            if (candCap.getModule().isResolved()) continue;
            try {
                this.populate(state, candCap.getModule());
            }
            catch (ResolveException ex) {
                if (rethrow == null) {
                    rethrow = ex;
                }
                itCandCap.remove();
            }
        }
        if (candidates.isEmpty()) {
            if (rethrow == null) {
                rethrow = new ResolveException("Dynamic import failed.", module, dynReq);
            }
            throw rethrow;
        }
    }

    private void add(Requirement req, SortedSet<Capability> candidates) {
        boolean isFragment = req.getNamespace().equals("host");
        this.m_candidateMap.put(req, candidates);
        for (Capability cap : candidates) {
            List<Requirement> actual;
            Map<Version, List<Requirement>> fragmentVersions;
            Set<Requirement> dependents = this.m_dependentMap.get(cap);
            if (dependents == null) {
                dependents = new HashSet<Requirement>();
                this.m_dependentMap.put(cap, dependents);
            }
            dependents.add(req);
            if (!isFragment) continue;
            Map<String, Map<Version, List<Requirement>>> fragments = this.m_hostFragments.get(cap);
            if (fragments == null) {
                fragments = new HashMap<String, Map<Version, List<Requirement>>>();
                this.m_hostFragments.put(cap, fragments);
            }
            if ((fragmentVersions = fragments.get(req.getModule().getSymbolicName())) == null) {
                fragmentVersions = new TreeMap(Collections.reverseOrder());
                fragments.put(req.getModule().getSymbolicName(), fragmentVersions);
            }
            if ((actual = fragmentVersions.get(req.getModule().getVersion())) == null) {
                actual = new ArrayList<Requirement>();
                fragmentVersions.put(req.getModule().getVersion(), actual);
            }
            actual.add(req);
        }
    }

    private void add(Map<Requirement, SortedSet<Capability>> candidates) {
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : candidates.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Module getWrappedHost(Module m) {
        Module wrapped = this.m_allWrappedHosts.get(m);
        return wrapped == null ? m : wrapped;
    }

    public SortedSet<Capability> getCandidates(Requirement req) {
        return this.m_candidateMap.get(req);
    }

    public void mergeFragments() throws ResolveException {
        ArrayList<HostModule> wrappedHosts = new ArrayList<HostModule>();
        ArrayList<Module> unselectedFragments = new ArrayList<Module>();
        for (Map.Entry<Capability, Map<String, Map<Version, List<Requirement>>>> hostEntry : this.m_hostFragments.entrySet()) {
            Capability hostCap = hostEntry.getKey();
            Map<String, Map<Version, List<Requirement>>> fragments = hostEntry.getValue();
            ArrayList<Module> selectedFragments = new ArrayList<Module>();
            for (Map.Entry<String, Map<Version, List<Requirement>>> fragEntry : fragments.entrySet()) {
                boolean isFirst = true;
                for (Map.Entry<Version, List<Requirement>> versionEntry : fragEntry.getValue().entrySet()) {
                    for (Requirement hostReq : versionEntry.getValue()) {
                        if (isFirst && !hostReq.getModule().isRemovalPending()) {
                            selectedFragments.add(hostReq.getModule());
                            isFirst = false;
                            continue;
                        }
                        this.m_dependentMap.get(hostCap).remove(hostReq);
                        SortedSet<Capability> hosts = this.m_candidateMap.get(hostReq);
                        hosts.remove(hostCap);
                        if (!hosts.isEmpty()) continue;
                        unselectedFragments.add(hostReq.getModule());
                    }
                }
            }
            HostModule wrappedHost = new HostModule(hostCap.getModule(), selectedFragments);
            wrappedHosts.add(wrappedHost);
            this.m_allWrappedHosts.put(hostCap.getModule(), wrappedHost);
        }
        for (Module m : unselectedFragments) {
            this.unselectFragment(m);
        }
        for (HostModule wrappedHost : wrappedHosts) {
            for (Capability c : wrappedHost.getCapabilities()) {
                Set<Requirement> dependents = this.m_dependentMap.get(((HostedCapability)c).getDeclaredCapability());
                if (dependents == null) continue;
                for (Requirement r : dependents) {
                    Set cands = this.m_candidateMap.get(r);
                    cands.remove(((HostedCapability)c).getDeclaredCapability());
                    cands.add(c);
                }
            }
            for (Requirement r : wrappedHost.getRequirements()) {
                SortedSet<Capability> cands = this.m_candidateMap.get(((HostedRequirement)r).getDeclaredRequirement());
                if (cands == null) continue;
                this.m_candidateMap.put(r, new TreeSet<Capability>(cands));
            }
        }
    }

    private void unselectFragment(Module fragment) throws ResolveException {
        HashSet<Module> unresolvedModules = new HashSet<Module>();
        this.remove(fragment, unresolvedModules);
        while (!unresolvedModules.isEmpty()) {
            Iterator it = unresolvedModules.iterator();
            fragment = (Module)it.next();
            it.remove();
            this.remove(fragment, unresolvedModules);
        }
    }

    private void remove(Module m, Set<Module> unresolvedModules) throws ResolveException {
        for (Requirement r : m.getRequirements()) {
            this.remove(r);
        }
        for (Capability c : m.getCapabilities()) {
            this.remove(c, unresolvedModules);
        }
    }

    private void remove(Requirement req) {
        boolean isFragment = req.getNamespace().equals("host");
        SortedSet<Capability> candidates = this.m_candidateMap.remove(req);
        if (candidates != null) {
            for (Capability cap : candidates) {
                List<Requirement> actual;
                Map<Version, List<Requirement>> fragmentVersions;
                Map<String, Map<Version, List<Requirement>>> fragments;
                Set<Requirement> dependents = this.m_dependentMap.get(cap);
                if (dependents != null) {
                    dependents.remove(req);
                }
                if (!isFragment || (fragments = this.m_hostFragments.get(cap)) == null || (fragmentVersions = fragments.get(req.getModule().getSymbolicName())) == null || (actual = fragmentVersions.get(req.getModule().getVersion())) == null) continue;
                actual.remove(req);
                if (!actual.isEmpty()) continue;
                fragmentVersions.remove(req.getModule().getVersion());
                if (!fragmentVersions.isEmpty()) continue;
                fragments.remove(req.getModule().getSymbolicName());
                if (!fragments.isEmpty()) continue;
                this.m_hostFragments.remove(cap);
            }
        }
    }

    private void remove(Capability c, Set<Module> unresolvedModules) throws ResolveException {
        Set<Requirement> dependents = this.m_dependentMap.remove(c);
        if (dependents != null) {
            for (Requirement r : dependents) {
                SortedSet<Capability> candidates = this.m_candidateMap.get(r);
                candidates.remove(c);
                if (!candidates.isEmpty()) continue;
                this.m_candidateMap.remove(r);
                if (r.isOptional()) continue;
                if (this.m_root.equals(r.getModule())) {
                    String msg = new StringBuffer().append("Unable to resolve ").append(this.m_root).append(": missing requirement ").append(r).toString();
                    ResolveException ex = new ResolveException(msg, this.m_root, r);
                    throw ex;
                }
                unresolvedModules.add(r.getModule());
            }
        }
    }

    public Candidates copy() {
        HashMap<Capability, Set<Requirement>> dependentMap = new HashMap<Capability, Set<Requirement>>();
        for (Map.Entry<Capability, Set<Requirement>> entry : this.m_dependentMap.entrySet()) {
            HashSet dependents = new HashSet(entry.getValue());
            dependentMap.put(entry.getKey(), dependents);
        }
        HashMap<Requirement, SortedSet<Capability>> candidateMap = new HashMap<Requirement, SortedSet<Capability>>();
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : this.m_candidateMap.entrySet()) {
            TreeSet<Capability> candidates = new TreeSet<Capability>(entry.getValue());
            candidateMap.put(entry.getKey(), candidates);
        }
        return new Candidates(this.m_root, dependentMap, candidateMap, this.m_hostFragments, this.m_allWrappedHosts, this.m_populateResultCache);
    }

    public void dump() {
        HashSet<Module> modules = new HashSet<Module>();
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : this.m_candidateMap.entrySet()) {
            modules.add(entry.getKey().getModule());
        }
        System.out.println("=== BEGIN CANDIDATE MAP ===");
        for (Module module : modules) {
            Set candidates;
            System.out.println(new StringBuffer().append("  ").append(module).append(" (").append(module.isResolved() ? "RESOLVED)" : "UNRESOLVED)").toString());
            for (Requirement req : module.getRequirements()) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println(new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
            for (Requirement req : module.getDynamicRequirements()) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println(new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
        }
        System.out.println("=== END CANDIDATE MAP ===");
    }
}

