/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jline.TerminalSupport;
import jline.console.Key;
import jline.internal.ReplayPrefixOneCharInputStream;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;

public class SshTerminal
extends TerminalSupport {
    private Environment environment;
    private String encoding = System.getProperty("input.encoding", "UTF-8");
    private ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    private InputStreamReader replayReader;
    private boolean deleteSendsBackspace = false;
    private boolean backspaceSendsDelete = false;

    public SshTerminal(Environment environment) {
        super(true);
        this.setAnsiSupported(true);
        this.environment = environment;
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Integer verase = (Integer)this.environment.getPtyModes().get(PtyMode.VERASE);
        this.deleteSendsBackspace = verase != null && verase == Key.DELETE.code;
    }

    public void init() throws Exception {
    }

    public void restore() throws Exception {
    }

    public int getWidth() {
        int width = 0;
        try {
            width = Integer.valueOf((String)this.environment.getEnv().get("COLUMNS"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return width > 0 ? width : super.getWidth();
    }

    public int getHeight() {
        int height = 0;
        try {
            height = Integer.valueOf((String)this.environment.getEnv().get("LINES"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return height > 0 ? height : super.getHeight();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (Key.valueOf((int)c) == Key.DELETE && this.deleteSendsBackspace) {
            c = Key.BACKSPACE.code;
        } else if (Key.valueOf((int)c) == Key.BACKSPACE && this.backspaceSendsDelete) {
            c = Key.DELETE.code;
        }
        UnixKey key = UnixKey.valueOf(c);
        if (key == UnixKey.ARROW_START) {
            while (key == UnixKey.ARROW_START) {
                c = this.readCharacter(in);
                key = UnixKey.valueOf(c);
            }
            if (key == UnixKey.ARROW_PREFIX || key == UnixKey.O_PREFIX) {
                c = this.readCharacter(in);
                key = UnixKey.valueOf(c);
                if (key == UnixKey.ARROW_UP) {
                    return Key.CTRL_P.code;
                }
                if (key == UnixKey.ARROW_DOWN) {
                    return Key.CTRL_N.code;
                }
                if (key == UnixKey.ARROW_LEFT) {
                    return Key.CTRL_B.code;
                }
                if (key == UnixKey.ARROW_RIGHT) {
                    return Key.CTRL_F.code;
                }
                if (key == UnixKey.HOME_CODE) {
                    return Key.CTRL_A.code;
                }
                if (key == UnixKey.END_CODE) {
                    return Key.CTRL_E.code;
                }
                if (key == UnixKey.DEL_THIRD) {
                    this.readCharacter(in);
                    return Key.DELETE.code;
                }
            }
        }
        if (c > 128) {
            this.replayStream.setInput(c, in);
            c = this.replayReader.read();
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnixKey {
        ARROW_START(27),
        ARROW_PREFIX(91),
        ARROW_LEFT(68),
        ARROW_RIGHT(67),
        ARROW_UP(65),
        ARROW_DOWN(66),
        O_PREFIX(79),
        HOME_CODE(72),
        END_CODE(70),
        DEL_THIRD(51),
        DEL_SECOND(126);

        public final short code;
        private static final Map<Short, UnixKey> codes;

        private UnixKey(int code) {
            this.code = (short)code;
        }

        public static UnixKey valueOf(int code) {
            return codes.get((short)code);
        }

        static {
            HashMap<Short, UnixKey> map = new HashMap<Short, UnixKey>();
            for (UnixKey key : UnixKey.values()) {
                map.put(key.code, key);
            }
            codes = map;
        }
    }
}

