/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.OpCodes;
import aQute.lib.osgi.Resource;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clazz {
    public static EnumSet<QUERY> HAS_ARGUMENT = EnumSet.of(QUERY.IMPLEMENTS, new QUERY[]{QUERY.EXTENDS, QUERY.IMPORTS, QUERY.NAMED, QUERY.VERSION, QUERY.ANNOTATION});
    static final byte[] SkipTable;
    boolean isAbstract;
    boolean isPublic;
    boolean hasRuntimeAnnotations;
    boolean hasClassAnnotations;
    String className;
    Object[] pool;
    int[] intPool;
    Map<String, Map<String, String>> imports = new HashMap<String, Map<String, String>>();
    String path;
    int minor = 0;
    int major = 0;
    String sourceFile;
    Set<String> xref;
    Set<Integer> classes;
    Set<Integer> descriptors;
    Set<String> annotations;
    int forName = 0;
    int class$ = 0;
    String[] interfaces;
    String zuper;
    ClassDataCollector cd = null;
    Resource resource;

    static {
        byte[] byArray = new byte[13];
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 8;
        byArray[6] = 8;
        byArray[7] = -1;
        byArray[8] = 2;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        SkipTable = byArray;
    }

    public Clazz(String path, Resource resource) {
        this.path = path;
        this.resource = resource;
    }

    public Set<String> parseClassFile() throws IOException {
        return this.parseClassFileWithCollector(null);
    }

    public Set<String> parseClassFile(InputStream in) throws IOException {
        return this.parseClassFile(in, null);
    }

    public Set<String> parseClassFileWithCollector(ClassDataCollector cd) throws IOException {
        InputStream in = this.resource.openInputStream();
        try {
            Set<String> set = this.parseClassFile(in, cd);
            return set;
        }
        finally {
            in.close();
        }
    }

    public Set<String> parseClassFile(InputStream in, ClassDataCollector cd) throws IOException {
        DataInputStream din = new DataInputStream(in);
        try {
            this.cd = cd;
            Set<String> set = this.parseClassFile(din);
            return set;
        }
        finally {
            cd = null;
            din.close();
        }
    }

    Set<String> parseClassFile(DataInputStream in) throws IOException {
        this.xref = new HashSet<String>();
        this.classes = new HashSet<Integer>();
        this.descriptors = new HashSet<Integer>();
        boolean crawl = false;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        int count = in.readUnsignedShort();
        this.pool = new Object[count];
        this.intPool = new int[count];
        int poolIndex = 1;
        block15: while (poolIndex < count) {
            byte tag = in.readByte();
            switch (tag) {
                case 0: {
                    break block15;
                }
                case 1: {
                    this.constantUtf8(in, poolIndex);
                    break;
                }
                case 3: {
                    this.constantInteger(in, poolIndex);
                    break;
                }
                case 4: {
                    this.constantFloat(in, poolIndex);
                    break;
                }
                case 5: {
                    this.constantLong(in, poolIndex);
                    ++poolIndex;
                    break;
                }
                case 6: {
                    this.constantDouble(in, poolIndex);
                    ++poolIndex;
                    break;
                }
                case 7: {
                    this.constantClass(in, poolIndex);
                    break;
                }
                case 8: {
                    this.constantString(in, poolIndex);
                    break;
                }
                case 10: {
                    this.methodRef(in, poolIndex);
                    break;
                }
                case 12: {
                    this.nameAndType(in, poolIndex, tag);
                    break;
                }
                default: {
                    if (tag == 2) {
                        throw new IOException("Invalid tag " + tag);
                    }
                    in.skipBytes(SkipTable[tag]);
                }
            }
            ++poolIndex;
        }
        this.pool(this.pool, this.intPool);
        int access_flags = in.readUnsignedShort();
        this.isAbstract = Modifier.isAbstract(access_flags);
        this.isPublic = Modifier.isPublic(access_flags);
        int this_class = in.readUnsignedShort();
        this.className = (String)this.pool[this.intPool[this_class]];
        if (this.cd != null) {
            this.cd.classBegin(access_flags, this.className);
        }
        try {
            int interfacesCount;
            int super_class = in.readUnsignedShort();
            this.zuper = (String)this.pool[this.intPool[super_class]];
            if (this.zuper != null) {
                String pack = Clazz.getPackage(this.zuper);
                this.packageReference(pack);
                if (this.cd != null) {
                    this.cd.extendsClass(this.zuper);
                }
            }
            if ((interfacesCount = in.readUnsignedShort()) > 0) {
                this.interfaces = new String[interfacesCount];
                int i = 0;
                while (i < interfacesCount) {
                    this.interfaces[i] = (String)this.pool[this.intPool[in.readUnsignedShort()]];
                    ++i;
                }
                if (this.cd != null) {
                    this.cd.implementsInterfaces(this.interfaces);
                }
            }
            int fieldsCount = in.readUnsignedShort();
            int i = 0;
            while (i < fieldsCount) {
                access_flags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                int descriptor_index = in.readUnsignedShort();
                String name = this.pool[name_index].toString();
                if (name.startsWith("class$")) {
                    crawl = true;
                }
                if (this.cd != null) {
                    this.cd.field(access_flags, this.pool[descriptor_index].toString());
                }
                this.descriptors.add(new Integer(descriptor_index));
                this.doAttributes(in, ElementType.FIELD, false);
                ++i;
            }
            if (crawl) {
                this.forName = this.findMethod("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                this.class$ = this.findMethod(this.className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
            }
            int methodCount = in.readUnsignedShort();
            int i2 = 0;
            while (i2 < methodCount) {
                access_flags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                int descriptor_index = in.readUnsignedShort();
                this.descriptors.add(new Integer(descriptor_index));
                String name = this.pool[name_index].toString();
                String descriptor = this.pool[descriptor_index].toString();
                if ("<init>".equals(name)) {
                    if (this.cd != null) {
                        this.cd.constructor(access_flags, descriptor);
                    }
                    this.doAttributes(in, ElementType.CONSTRUCTOR, crawl);
                } else {
                    if (this.cd != null) {
                        this.cd.method(access_flags, name, descriptor);
                    }
                    this.doAttributes(in, ElementType.METHOD, crawl);
                }
                ++i2;
            }
            this.doAttributes(in, ElementType.TYPE, false);
            for (int n : this.classes) {
                String clazz = (String)this.pool[n];
                if (clazz.endsWith(";") || clazz.startsWith("[")) {
                    this.parseReference(clazz, 0);
                    continue;
                }
                String pack = Clazz.getPackage(clazz);
                this.packageReference(pack);
            }
            for (Integer index : this.descriptors) {
                String prototype = (String)this.pool[index];
                if (prototype != null) {
                    this.parseDescriptor(prototype);
                    continue;
                }
                System.err.println("Unrecognized descriptor: " + index);
            }
            Set<String> xref = this.xref;
            this.reset();
            Set<String> set = xref;
            return set;
        }
        finally {
            if (this.cd != null) {
                this.cd.classEnd();
            }
        }
    }

    private void constantFloat(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readInt();
        } else {
            in.skipBytes(4);
        }
    }

    private void constantInteger(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.intPool[poolIndex] = in.readInt();
        } else {
            in.skipBytes(4);
        }
    }

    protected void pool(Object[] pool, int[] intPool) {
    }

    protected void nameAndType(DataInputStream in, int poolIndex, byte tag) throws IOException {
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        this.descriptors.add(new Integer(descriptor_index));
        this.pool[poolIndex] = new Assoc(tag, name_index, descriptor_index);
    }

    private void methodRef(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(10, class_index, name_and_type_index);
    }

    private void constantString(DataInputStream in, int poolIndex) throws IOException {
        int string_index;
        this.intPool[poolIndex] = string_index = in.readUnsignedShort();
    }

    protected void constantClass(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        this.classes.add(new Integer(class_index));
        this.intPool[poolIndex] = class_index;
    }

    protected void constantDouble(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readDouble();
        } else {
            in.skipBytes(8);
        }
    }

    protected void constantLong(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readLong();
        } else {
            in.skipBytes(8);
        }
    }

    protected void constantUtf8(DataInputStream in, int poolIndex) throws IOException {
        String name = in.readUTF();
        this.xref.add(name);
        this.pool[poolIndex] = name;
    }

    private int findMethod(String clazz, String methodname, String descriptor) {
        int i = 1;
        while (i < this.pool.length) {
            if (this.pool[i] instanceof Assoc) {
                int class_index;
                int class_name_index;
                Assoc methodref = (Assoc)this.pool[i];
                if (methodref.tag == 10 && clazz.equals(this.pool[class_name_index = this.intPool[class_index = methodref.a]])) {
                    int name_and_type_index = methodref.b;
                    Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
                    if (name_and_type.tag == 12) {
                        int name_index = name_and_type.a;
                        int type_index = name_and_type.b;
                        if (methodname.equals(this.pool[name_index]) && descriptor.equals(this.pool[type_index])) {
                            return i;
                        }
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    private void doAttributes(DataInputStream in, ElementType member, boolean crawl) throws IOException {
        int attributesCount = in.readUnsignedShort();
        int j = 0;
        while (j < attributesCount) {
            this.doAttribute(in, member, crawl);
            ++j;
        }
    }

    private void doAttribute(DataInputStream in, ElementType member, boolean crawl) throws IOException {
        int attribute_name_index = in.readUnsignedShort();
        String attributeName = (String)this.pool[attribute_name_index];
        long attribute_length = in.readInt();
        attribute_length &= 0xFFFFFFFFFFFFFFFFL;
        if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in, member, RetentionPolicy.RUNTIME);
        } else if ("RuntimeVisibleParameterAnnotations".equals(attributeName)) {
            this.doParameterAnnotations(in, member, RetentionPolicy.RUNTIME);
        } else if ("RuntimeInvisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in, member, RetentionPolicy.CLASS);
        } else if ("RuntimeInvisibleParameterAnnotations".equals(attributeName)) {
            this.doParameterAnnotations(in, member, RetentionPolicy.CLASS);
        } else if ("SourceFile".equals(attributeName)) {
            this.doSourceFile(in);
        } else if ("Code".equals(attributeName) && crawl) {
            this.doCode(in);
        } else if ("Signature".equals(attributeName)) {
            this.doSignature(in, member);
        } else {
            if (attribute_length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Attribute > 2Gb");
            }
            in.skipBytes((int)attribute_length);
        }
    }

    void doSignature(DataInputStream in, ElementType member) throws IOException {
        int signature_index = in.readUnsignedShort();
        String signature = (String)this.pool[signature_index];
        if (member != ElementType.TYPE) {
            this.parseDescriptor(signature);
        }
    }

    private void doCode(DataInputStream in) throws IOException {
        in.readUnsignedShort();
        in.readUnsignedShort();
        int code_length = in.readInt();
        byte[] code = new byte[code_length];
        in.readFully(code);
        this.crawl(code);
        int exception_table_length = in.readUnsignedShort();
        in.skipBytes(exception_table_length * 8);
        this.doAttributes(in, ElementType.METHOD, false);
    }

    protected void crawl(byte[] code) {
        ByteBuffer bb = ByteBuffer.wrap(code);
        bb.order(ByteOrder.BIG_ENDIAN);
        int lastReference = -1;
        block7: while (bb.remaining() > 0) {
            int instruction = 0xFF & bb.get();
            switch (instruction) {
                case 18: {
                    lastReference = 0xFF & bb.get();
                    break;
                }
                case 19: {
                    lastReference = 0xFFFF & bb.getShort();
                    break;
                }
                case 184: {
                    int methodref = 0xFFFF & bb.getShort();
                    if (methodref != this.forName && methodref != this.class$ || lastReference == -1 || !(this.pool[this.intPool[lastReference]] instanceof String)) continue block7;
                    String clazz = (String)this.pool[this.intPool[lastReference]];
                    if (clazz.startsWith("[") || clazz.endsWith(";")) {
                        this.parseReference(clazz, 0);
                        break;
                    }
                    int n = clazz.lastIndexOf(46);
                    if (n <= 0) continue block7;
                    this.packageReference(clazz.substring(0, n));
                    break;
                }
                case 170: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    bb.getInt();
                    int low = bb.getInt();
                    int high = bb.getInt();
                    bb.position(bb.position() + (high - low + 1) * 4);
                    lastReference = -1;
                    break;
                }
                case 171: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    bb.getInt();
                    int npairs = bb.getInt();
                    bb.position(bb.position() + npairs * 8);
                    lastReference = -1;
                    break;
                }
                default: {
                    lastReference = -1;
                    bb.position(bb.position() + OpCodes.OFFSETS[instruction]);
                }
            }
        }
    }

    private void doSourceFile(DataInputStream in) throws IOException {
        int sourcefile_index = in.readUnsignedShort();
        this.sourceFile = this.pool[sourcefile_index].toString();
    }

    private void doParameterAnnotations(DataInputStream in, ElementType member, RetentionPolicy policy) throws IOException {
        int num_parameters = in.readUnsignedByte();
        int p = 0;
        while (p < num_parameters) {
            if (this.cd != null) {
                this.cd.parameter(p);
            }
            this.doAnnotations(in, member, policy);
            ++p;
        }
    }

    private void doAnnotations(DataInputStream in, ElementType member, RetentionPolicy policy) throws IOException {
        int num_annotations = in.readUnsignedShort();
        int a = 0;
        while (a < num_annotations) {
            if (this.cd == null) {
                this.doAnnotation(in, member, policy, false);
            } else {
                Annotation annotion = this.doAnnotation(in, member, policy, true);
                this.cd.annotation(annotion);
            }
            ++a;
        }
    }

    private Annotation doAnnotation(DataInputStream in, ElementType member, RetentionPolicy policy, boolean collect) throws IOException {
        int type_index = in.readUnsignedShort();
        if (this.annotations == null) {
            this.annotations = new HashSet<String>();
        }
        this.annotations.add(this.pool[type_index].toString());
        if (policy == RetentionPolicy.RUNTIME) {
            this.descriptors.add(new Integer(type_index));
            this.hasRuntimeAnnotations = true;
        } else {
            this.hasClassAnnotations = true;
        }
        String name = (String)this.pool[type_index];
        int num_element_value_pairs = in.readUnsignedShort();
        LinkedHashMap<String, Object> elements = null;
        int v = 0;
        while (v < num_element_value_pairs) {
            int element_name_index = in.readUnsignedShort();
            String element = (String)this.pool[element_name_index];
            Object value = this.doElementValue(in, member, policy, collect);
            if (collect) {
                if (elements == null) {
                    elements = new LinkedHashMap<String, Object>();
                }
                elements.put(element, value);
            }
            ++v;
        }
        if (collect) {
            return new Annotation(name, elements, member, policy);
        }
        return null;
    }

    private Object doElementValue(DataInputStream in, ElementType member, RetentionPolicy policy, boolean collect) throws IOException {
        char tag = (char)in.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': {
                int const_value_index = in.readUnsignedShort();
                return this.intPool[const_value_index];
            }
            case 'D': 
            case 'F': 
            case 'J': 
            case 's': {
                int const_value_index = in.readUnsignedShort();
                return this.pool[const_value_index];
            }
            case 'Z': {
                int const_value_index = in.readUnsignedShort();
                return this.intPool[const_value_index] != 0;
            }
            case 'e': {
                int type_name_index = in.readUnsignedShort();
                if (policy == RetentionPolicy.RUNTIME) {
                    this.descriptors.add(new Integer(type_name_index));
                }
                int const_name_index = in.readUnsignedShort();
                return this.pool[const_name_index];
            }
            case 'c': {
                int class_info_index = in.readUnsignedShort();
                if (policy == RetentionPolicy.RUNTIME) {
                    this.descriptors.add(new Integer(class_info_index));
                }
                return this.pool[class_info_index];
            }
            case '@': {
                return this.doAnnotation(in, member, policy, collect);
            }
            case '[': {
                int num_values = in.readUnsignedShort();
                Object[] result = new Object[num_values];
                int i = 0;
                while (i < num_values) {
                    result[i] = this.doElementValue(in, member, policy, collect);
                    ++i;
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Invalid value for Annotation ElementValue tag " + tag);
    }

    void packageReference(String pack) {
        if (!this.imports.containsKey(pack)) {
            this.imports.put(pack, new LinkedHashMap());
        }
    }

    public void parseDescriptor(String descriptor) {
        if (descriptor.charAt(0) == '<') {
            return;
        }
        int rover = 0;
        if (descriptor.charAt(rover) == '(') {
            rover = this.parseReferences(descriptor, rover + 1, ')');
            ++rover;
        }
        this.parseReferences(descriptor, rover, '\u0000');
    }

    int parseReferences(String descriptor, int rover, char delimiter) {
        while (rover < descriptor.length() && descriptor.charAt(rover) != delimiter) {
            rover = this.parseReference(descriptor, rover);
        }
        return rover;
    }

    int parseReference(String descriptor, int rover) {
        char c = descriptor.charAt(rover);
        while (c == '[') {
            c = descriptor.charAt(++rover);
        }
        if (c == '<') {
            rover = this.parseReferences(descriptor, rover + 1, '>');
        } else if (c == 'T') {
            ++rover;
            while (descriptor.charAt(rover) != ';') {
                ++rover;
            }
        } else if (c == 'L') {
            StringBuilder sb = new StringBuilder();
            ++rover;
            int lastSlash = -1;
            while ((c = descriptor.charAt(rover)) != ';') {
                if (c == '<') {
                    rover = this.parseReferences(descriptor, rover + 1, '>');
                } else if (c == '/') {
                    lastSlash = sb.length();
                    sb.append('.');
                } else {
                    sb.append(c);
                }
                ++rover;
            }
            if (this.cd != null) {
                this.cd.addReference(sb.toString());
            }
            if (lastSlash > 0) {
                this.packageReference(sb.substring(0, lastSlash));
            }
        } else if ("+-*BCDFIJSZV".indexOf(c) < 0) {
            System.out.println("Should not skip: " + c);
        }
        return rover + 1;
    }

    public static String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    public Map<String, Map<String, String>> getReferred() {
        return this.imports;
    }

    String getClassName() {
        return this.className;
    }

    public String getPath() {
        return this.path;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void reset() {
        this.pool = null;
        this.intPool = null;
        this.xref = null;
        this.classes = null;
        this.descriptors = null;
    }

    public boolean is(QUERY query, Instruction instr, Map<String, Clazz> classspace) {
        switch (query) {
            case ANY: {
                return true;
            }
            case NAMED: {
                if (instr.matches(this.getClassName())) {
                    return !instr.isNegated();
                }
                return false;
            }
            case VERSION: {
                String v = String.valueOf(this.major) + "/" + this.minor;
                if (instr.matches(v)) {
                    return !instr.isNegated();
                }
                return false;
            }
            case IMPLEMENTS: {
                int i = 0;
                while (this.interfaces != null && i < this.interfaces.length) {
                    if (instr.matches(this.interfaces[i])) {
                        return !instr.isNegated();
                    }
                    ++i;
                }
                break;
            }
            case EXTENDS: {
                if (this.zuper == null) {
                    return false;
                }
                if (!instr.matches(this.zuper)) break;
                return !instr.isNegated();
            }
            case PUBLIC: {
                return !this.isPublic;
            }
            case CONCRETE: {
                return !this.isAbstract;
            }
            case ANNOTATION: {
                if (this.annotations == null) {
                    return false;
                }
                for (String annotation : this.annotations) {
                    if (!instr.matches(annotation)) continue;
                    return !instr.isNegated();
                }
                return false;
            }
            case RUNTIMEANNOTATIONS: {
                return this.hasClassAnnotations;
            }
            case CLASSANNOTATIONS: {
                return this.hasClassAnnotations;
            }
            case ABSTRACT: {
                return this.isAbstract;
            }
            case IMPORTS: {
                for (String imp : this.imports.keySet()) {
                    if (!instr.matches(imp.replace('.', '/'))) continue;
                    return !instr.isNegated();
                }
                break;
            }
        }
        if (this.zuper == null || classspace == null) {
            return false;
        }
        Clazz clazz = classspace.get(String.valueOf(this.zuper) + ".class");
        if (clazz == null) {
            return false;
        }
        return clazz.is(query, instr, classspace);
    }

    public String toString() {
        return this.getFQN();
    }

    public String getFQN() {
        return this.getClassName().replace('/', '.');
    }

    protected static class Assoc {
        byte tag;
        int a;
        int b;

        Assoc(byte tag, int a, int b) {
            this.tag = tag;
            this.a = a;
            this.b = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QUERY {
        IMPLEMENTS,
        EXTENDS,
        IMPORTS,
        NAMED,
        ANY,
        VERSION,
        CONCRETE,
        ABSTRACT,
        PUBLIC,
        ANNOTATION,
        RUNTIMEANNOTATIONS,
        CLASSANNOTATIONS;

    }
}

