/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="dev", name="threads", description="Show threads in the JVM.")
public class Threads
extends OsgiCommandSupport {
    @Option(name="-f", aliases={"--flat"}, description="Do not display threads as a tree")
    private boolean flat;

    protected Object doExecute() throws Exception {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        this.print(group, "");
        return null;
    }

    void print(ThreadGroup group, String indent) {
        int nb;
        if (!this.flat) {
            System.out.println(indent + "Thread Group \"" + group.getName() + "\"");
        }
        ThreadGroup[] childGroups = new ThreadGroup[32];
        while ((nb = group.enumerate(childGroups, false)) == childGroups.length) {
            childGroups = new ThreadGroup[childGroups.length * 2];
        }
        for (int i = 0; i < nb; ++i) {
            this.print(childGroups[i], indent + (this.flat ? "" : "    "));
        }
        Thread[] childThreads = new Thread[32];
        while ((nb = group.enumerate(childThreads, false)) == childThreads.length) {
            childThreads = new Thread[childThreads.length * 2];
        }
        for (int i = 0; i < nb; ++i) {
            System.out.println(indent + (this.flat ? "" : "    ") + "\"" + childThreads[i].getName() + "\": " + (Object)((Object)childThreads[i].getState()));
        }
    }
}

