/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.shell.osgi.BundleStateListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintListener
implements org.osgi.service.blueprint.container.BlueprintListener,
BundleListener,
BundleStateListener,
BundleStateListener.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintListener.class);
    private final Map<Long, BlueprintState> states = new ConcurrentHashMap<Long, BlueprintState>();
    private BundleContext bundleContext;

    public String getName() {
        return "Blueprint   ";
    }

    public String getState(Bundle bundle) {
        BlueprintState state = this.states.get(bundle.getBundleId());
        if (state == null || bundle.getState() != 32 || state == BlueprintState.Unknown) {
            return null;
        }
        return state.toString();
    }

    public BundleStateListener getListener() {
        return this;
    }

    public BlueprintState getBlueprintState(Bundle bundle) {
        BlueprintState state = this.states.get(bundle.getBundleId());
        if (state == null || bundle.getState() != 32) {
            state = BlueprintState.Unknown;
        }
        return state;
    }

    public void blueprintEvent(BlueprintEvent blueprintEvent) {
        BlueprintState state = this.getState(blueprintEvent);
        LOG.debug("Blueprint app state changed to " + (Object)((Object)state) + " for bundle " + blueprintEvent.getBundle().getBundleId());
        this.states.put(blueprintEvent.getBundle().getBundleId(), state);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.states.remove(event.getBundle().getBundleId());
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void destroy() throws Exception {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    private BlueprintState getState(BlueprintEvent blueprintEvent) {
        switch (blueprintEvent.getType()) {
            case 1: {
                return BlueprintState.Creating;
            }
            case 2: {
                return BlueprintState.Created;
            }
            case 3: {
                return BlueprintState.Destroying;
            }
            case 4: {
                return BlueprintState.Destroyed;
            }
            case 5: {
                return BlueprintState.Failure;
            }
            case 6: {
                return BlueprintState.GracePeriod;
            }
            case 7: {
                return BlueprintState.Waiting;
            }
        }
        return BlueprintState.Unknown;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlueprintState {
        Unknown,
        Creating,
        Created,
        Destroying,
        Destroyed,
        Failure,
        GracePeriod,
        Waiting;

    }
}

