/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Terminal;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.console.history.PersistentHistory;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.CloseShellException;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.CommandsCompleter;
import org.apache.karaf.shell.console.jline.CompleterAsCompletor;
import org.apache.karaf.shell.console.jline.KarafFileHistory;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements Runnable {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String PROMPT = "PROMPT";
    public static final String DEFAULT_PROMPT = "\u001b[1m${USER}\u001b[0m@${APPLICATION}> ";
    public static final String PRINT_STACK_TRACES = "karaf.printStackTraces";
    public static final String LAST_EXCEPTION = "karaf.lastException";
    public static final String IGNORE_INTERRUPTS = "karaf.ignoreInterrupts";
    private static final Logger LOGGER = LoggerFactory.getLogger(Console.class);
    protected CommandSession session;
    private ConsoleReader reader;
    private BlockingQueue<Integer> queue;
    private boolean interrupt;
    private Thread pipe;
    private volatile boolean running;
    private volatile boolean eof;
    private Runnable closeCallback;
    private Terminal terminal;
    private InputStream consoleInput;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private Thread thread;

    public Console(CommandProcessor processor, InputStream in, PrintStream out, PrintStream err, Terminal term, Runnable closeCallback) throws Exception {
        this.in = in;
        this.out = out;
        this.err = err;
        this.queue = new ArrayBlockingQueue<Integer>(1024);
        this.terminal = term == null ? new UnsupportedTerminal() : term;
        this.consoleInput = new ConsoleInputStream();
        this.session = processor.createSession(this.consoleInput, this.out, this.err);
        this.session.put("SCOPE", "shell:osgi:*");
        this.closeCallback = closeCallback;
        this.reader = new ConsoleReader(this.consoleInput, new PrintWriter(this.out), this.getClass().getResourceAsStream("keybinding.properties"), this.terminal);
        File file = this.getHistoryFile();
        try {
            file.getParentFile().mkdirs();
            this.reader.setHistory(new KarafFileHistory(file));
        }
        catch (Exception e) {
            LOGGER.error("Can not read history from file " + file + ". Using in memory history", (Throwable)e);
        }
        this.session.put(".jline.history", this.reader.getHistory());
        Completer completer = this.createCompleter();
        if (completer != null) {
            this.reader.addCompleter(new CompleterAsCompletor(completer));
        }
        if (Boolean.getBoolean("jline.nobell")) {
            this.reader.setBellEnabled(false);
        }
        this.pipe = new Thread(new Pipe());
        this.pipe.setName("gogo shell pipe thread");
        this.pipe.setDaemon(true);
    }

    protected File getHistoryFile() {
        return new File(System.getProperty("karaf.history", new File(System.getProperty("user.home"), ".karaf/karaf.history").toString()));
    }

    public CommandSession getSession() {
        return this.session;
    }

    public void close() {
        if (this.reader.getHistory() instanceof PersistentHistory) {
            try {
                ((PersistentHistory)this.reader.getHistory()).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.running = false;
        this.pipe.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread = Thread.currentThread();
        this.running = true;
        this.pipe.start();
        this.welcome();
        this.setSessionProperties();
        String scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                this.session.execute(new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
                System.err.println("Error in initialization script: " + e.getMessage());
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        while (this.running) {
            try {
                String command = null;
                boolean loop = true;
                boolean first = true;
                while (loop) {
                    this.checkInterrupt();
                    String line = this.reader.readLine(first ? this.getPrompt() : "> ");
                    if (line == null) break;
                    command = command == null ? line : command + " " + line;
                    if (this.reader.getHistory().size() == 0) {
                        this.reader.getHistory().add(command);
                    } else {
                        this.reader.getHistory().replace(command);
                    }
                    try {
                        new Parser(command).program();
                        loop = false;
                    }
                    catch (Exception e) {
                        loop = true;
                        first = false;
                    }
                }
                if (command == null) break;
                Object result = this.session.execute(command);
                if (result == null) continue;
                this.session.getConsole().println(this.session.format(result, 0));
            }
            catch (InterruptedIOException e) {
            }
            catch (CloseShellException e) {
                break;
            }
            catch (Throwable t) {
                try {
                    LOGGER.info("Exception caught while executing command", t);
                    this.session.put(LAST_EXCEPTION, t);
                    if (t instanceof CommandException) {
                        this.session.getConsole().println(((CommandException)t).getNiceHelp());
                    } else if (t instanceof CommandNotFoundException) {
                        String str = Ansi.ansi().fg(Ansi.Color.RED).a("Command not found: ").a(Ansi.Attribute.INTENSITY_BOLD).a(((CommandNotFoundException)t).getCommand()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString();
                        this.session.getConsole().println(str);
                    }
                    if (this.getBoolean(PRINT_STACK_TRACES)) {
                        this.session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                        t.printStackTrace(this.session.getConsole());
                        this.session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                        continue;
                    }
                    if (t instanceof CommandException || t instanceof CommandNotFoundException) continue;
                    this.session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                    this.session.getConsole().println("Error executing command: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
                    this.session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                }
                catch (Exception exception) {}
            }
        }
        this.close();
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    protected boolean getBoolean(String name) {
        Object s = this.session.get(name);
        if (s == null) {
            s = System.getProperty(name);
        }
        if (s == null) {
            return false;
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return Boolean.parseBoolean(s.toString());
    }

    protected void welcome() {
        Properties props = this.loadBrandingProperties();
        String welcome = props.getProperty("welcome");
        if (welcome != null && welcome.length() > 0) {
            this.session.getConsole().println(welcome);
        }
    }

    protected void setSessionProperties() {
        Properties props = this.loadBrandingProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("session.")) continue;
            this.session.put(key.substring("session.".length()), entry.getValue());
        }
    }

    protected Completer createCompleter() {
        return new CommandsCompleter(this.session);
    }

    protected Properties loadBrandingProperties() {
        Properties props = new Properties();
        this.loadProps(props, "org/apache/karaf/shell/console/branding.properties");
        this.loadProps(props, "org/apache/karaf/branding/branding.properties");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProps(Properties props, String resource) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(resource);
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String getPrompt() {
        try {
            String prompt;
            try {
                Object p = this.session.get(PROMPT);
                if (p != null) {
                    prompt = p.toString();
                } else {
                    Properties properties = this.loadBrandingProperties();
                    if (properties.getProperty("prompt") != null) {
                        prompt = properties.getProperty("prompt");
                        this.session.put(PROMPT, prompt);
                    } else {
                        prompt = DEFAULT_PROMPT;
                    }
                }
            }
            catch (Throwable t) {
                prompt = DEFAULT_PROMPT;
            }
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(prompt);
            while (matcher.find()) {
                Object rep = this.session.get(matcher.group(1));
                if (rep == null) continue;
                prompt = prompt.replace(matcher.group(0), rep.toString());
                matcher.reset(prompt);
            }
            return prompt;
        }
        catch (Throwable t) {
            return "$ ";
        }
    }

    private void checkInterrupt() throws IOException {
        if (Thread.interrupted() || this.interrupt) {
            this.interrupt = false;
            throw new InterruptedIOException("Keyboard interruption");
        }
    }

    private void interrupt() {
        this.interrupt = true;
        this.thread.interrupt();
    }

    private class Pipe
    implements Runnable {
        private Pipe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (Console.this.running) {
                    int c;
                    try {
                        c = Console.this.terminal.readCharacter(Console.this.in);
                        if (c == -1) {
                            return;
                        }
                    }
                    catch (Throwable t) {
                        Console.this.eof = true;
                        try {
                            Console.this.queue.put(-1);
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return;
                    }
                    {
                        if (c == 4 && !Console.this.getBoolean(Console.IGNORE_INTERRUPTS)) {
                            Console.this.err.println("^D");
                        } else if (c == 3 && !Console.this.getBoolean(Console.IGNORE_INTERRUPTS)) {
                            Console.this.err.println("^C");
                            Console.this.reader.getCursorBuffer().clear();
                            Console.this.interrupt();
                        }
                        Console.this.queue.put(c);
                    }
                }
                return;
            }
            finally {
                Console.this.eof = true;
                try {
                    Console.this.queue.put(-1);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private class ConsoleInputStream
    extends InputStream {
        private ConsoleInputStream() {
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (!Console.this.running) {
                return -1;
            }
            Console.this.checkInterrupt();
            if (Console.this.eof && Console.this.queue.isEmpty()) {
                return -1;
            }
            if (wait) {
                try {
                    i = (Integer)Console.this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                Console.this.checkInterrupt();
            } else {
                i = (Integer)Console.this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int read() throws IOException {
            return this.read(true);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }

        public int available() throws IOException {
            return Console.this.queue.size();
        }
    }
}

