/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.CachingPersistenceManagerProxy;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationAdminFactory;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.DynamicBindings;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.RankingComparator;
import org.apache.felix.cm.impl.UpdateThread;
import org.apache.felix.framework.monitor.MonitoringService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationManager
implements BundleActivator,
BundleListener {
    public static final String CM_CONFIG_DIR = "felix.cm.dir";
    public static final String CM_LOG_LEVEL = "felix.cm.loglevel";
    private static final String LOG_SERVICE_NAME = "org.osgi.service.log.LogService";
    private static final int CM_LOG_LEVEL_DEFAULT = 2;
    private static Random numberGenerator;
    private static final Comparator cmRankComp;
    private BundleContext bundleContext;
    private volatile ServiceRegistration configurationAdminRegistration;
    private ServiceTracker logTracker;
    private ServiceTracker configurationListenerTracker;
    private ServiceTracker managedServiceTracker;
    private ServiceTracker managedServiceFactoryTracker;
    private ServiceTracker persistenceManagerTracker;
    private UpdateThread updateThread;
    private UpdateThread eventThread;
    private ExecutorServiceFinder executorServiceFinder;
    private PersistenceManager[] persistenceManagers;
    private int pmtCount;
    private final Map factories = new HashMap();
    private final Map configurations = new HashMap();
    private DynamicBindings dynamicBindings;
    private int logLevel = 2;
    private volatile boolean handleBundleEvents;

    public void start(BundleContext bundleContext) {
        Hashtable<String, Object> props;
        this.logTracker = new ServiceTracker(bundleContext, LOG_SERVICE_NAME, null);
        this.logTracker.open();
        String logLevelProp = bundleContext.getProperty(CM_LOG_LEVEL);
        if (logLevelProp == null) {
            this.logLevel = 2;
        } else {
            try {
                this.logLevel = Integer.parseInt(logLevelProp);
            }
            catch (NumberFormatException nfe) {
                this.logLevel = 2;
            }
        }
        this.bundleContext = bundleContext;
        FelixExecutorServiceFinder finder = null;
        try {
            finder = new FelixExecutorServiceFinder();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.executorServiceFinder = finder;
        this.configurationListenerTracker = new ServiceTracker(bundleContext, ConfigurationListener.class.getName(), null);
        this.configurationListenerTracker.open();
        ThreadGroup tg = this.getThreadGroup();
        this.updateThread = new UpdateThread(this, tg, "CM Configuration Updater");
        this.eventThread = new UpdateThread(this, tg, "CM Event Dispatcher");
        try {
            FilePersistenceManager fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(CM_CONFIG_DIR));
            props = new Hashtable<String, Object>();
            props.put("service.pid", fpm.getClass().getName());
            props.put("service.description", "Platform Filesystem Persistence Manager");
            props.put("service.vendor", "Apache Software Foundation");
            props.put("service.ranking", new Integer(Integer.MIN_VALUE));
            bundleContext.registerService(PersistenceManager.class.getName(), (Object)fpm, props);
            this.dynamicBindings = new DynamicBindings(bundleContext, fpm);
        }
        catch (IOException ioe) {
            this.log(1, "Failure setting up dynamic configuration bindings", ioe);
        }
        catch (IllegalArgumentException iae) {
            this.log(1, "Cannot create the FilePersistenceManager", iae);
        }
        this.handleBundleEvents = true;
        bundleContext.addBundleListener((BundleListener)this);
        this.pmtCount = 1;
        this.persistenceManagerTracker = new ServiceTracker(bundleContext, PersistenceManager.class.getName(), null);
        this.persistenceManagerTracker.open();
        ConfigurationAdminFactory caf = new ConfigurationAdminFactory(this);
        props = new Hashtable();
        props.put("service.pid", "org.apache.felix.cm.ConfigurationAdmin");
        props.put("service.description", "Configuration Admin Service Specification 1.2 Implementation");
        props.put("service.vendor", "Apache Software Foundation");
        this.configurationAdminRegistration = bundleContext.registerService(ConfigurationAdmin.class.getName(), (Object)caf, props);
        this.updateThread.start();
        this.eventThread.start();
        this.managedServiceTracker = new ManagedServiceTracker(this);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this);
    }

    private ThreadGroup getThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (this.bundleContext.getBundle() == null || !tg.getName().contains(this.bundleContext.getBundle().getSymbolicName())) {
            tg = new ThreadGroup("Configuration Admin Service");
            tg.setDaemon(true);
        }
        return tg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) {
        this.handleBundleEvents = false;
        if (this.updateThread != null) {
            this.updateThread.terminate();
        }
        if (this.eventThread != null) {
            this.eventThread.terminate();
        }
        if (this.configurationAdminRegistration != null) {
            ServiceRegistration reg = this.configurationAdminRegistration;
            this.configurationAdminRegistration = null;
            reg.unregister();
        }
        this.managedServiceFactoryTracker.close();
        this.managedServiceTracker.close();
        this.persistenceManagerTracker.close();
        bundleContext.removeBundleListener((BundleListener)this);
        if (this.configurationListenerTracker != null) {
            this.configurationListenerTracker.close();
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.clear();
        }
        map = this.factories;
        synchronized (map) {
            this.factories.clear();
        }
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl getCachedConfiguration(String pid) {
        Map map = this.configurations;
        synchronized (map) {
            return (ConfigurationImpl)this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl[] getCachedConfigurations() {
        Map map = this.configurations;
        synchronized (map) {
            return this.configurations.values().toArray(new ConfigurationImpl[this.configurations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationImpl cacheConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            Object existing = this.configurations.get(configuration.getPid());
            if (existing != null) {
                return (ConfigurationImpl)existing;
            }
            this.configurations.put(configuration.getPid(), configuration);
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConfiguration(ConfigurationImpl configuration) {
        Map map = this.configurations;
        synchronized (map) {
            this.configurations.remove(configuration.getPid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory getCachedFactory(String factoryPid) {
        Map map = this.factories;
        synchronized (map) {
            return (Factory)this.factories.get(factoryPid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory[] getCachedFactories() {
        Map map = this.factories;
        synchronized (map) {
            return this.factories.values().toArray(new Factory[this.factories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheFactory(Factory factory) {
        Map map = this.factories;
        synchronized (map) {
            this.factories.put(factory.getFactoryPid(), factory);
        }
    }

    void setDynamicBundleLocation(String pid, String location) {
        if (this.dynamicBindings != null) {
            try {
                this.dynamicBindings.putLocation(pid, location);
            }
            catch (IOException ioe) {
                this.log(1, "Failed storing dynamic configuration binding for " + pid + " to " + location, ioe);
            }
        }
    }

    String getDynamicBundleLocation(String pid) {
        if (this.dynamicBindings != null) {
            return this.dynamicBindings.getLocation(pid);
        }
        return null;
    }

    ConfigurationImpl createFactoryConfiguration(ConfigurationAdminImpl configurationAdmin, String factoryPid) throws IOException {
        Factory factory = this.getFactory(factoryPid);
        if (factory.getBundleLocation() != null && !factory.getBundleLocation().equals(configurationAdmin.getBundle().getLocation())) {
            configurationAdmin.checkPermission();
        }
        String pid = ConfigurationManager.createPid(factoryPid);
        ConfigurationImpl config = this.createConfiguration(pid, factoryPid, configurationAdmin.getBundle().getLocation());
        return config;
    }

    ConfigurationImpl createFactoryConfiguration(String factoryPid, String location) throws IOException {
        String pid = ConfigurationManager.createPid(factoryPid);
        ConfigurationImpl config = this.createConfiguration(pid, factoryPid, location);
        return config;
    }

    ConfigurationImpl getExistingConfiguration(String pid) throws IOException {
        ConfigurationImpl config = this.getCachedConfiguration(pid);
        if (config != null) {
            return config;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!pmList[i].exists(pid)) continue;
            Dictionary props = pmList[i].load(pid);
            config = new ConfigurationImpl(this, pmList[i], props);
            return this.cacheConfiguration(config);
        }
        return null;
    }

    ConfigurationImpl getConfiguration(String pid, String bundleLocation) throws IOException {
        ConfigurationImpl config = this.getExistingConfiguration(pid);
        if (config != null) {
            return config;
        }
        config = this.createConfiguration(pid, null, bundleLocation);
        return this.cacheConfiguration(config);
    }

    ConfigurationImpl[] listConfigurations(ConfigurationAdminImpl configurationAdmin, String filterString) throws IOException, InvalidSyntaxException {
        Filter filter = null;
        if (filterString != null) {
            filter = this.bundleContext.createFilter(filterString);
        }
        boolean unprivileged = configurationAdmin != null && !configurationAdmin.hasPermission();
        String location = unprivileged ? configurationAdmin.getBundle().getLocation() : null;
        ArrayList<ConfigurationImpl> configList = new ArrayList<ConfigurationImpl>();
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            Enumeration configs = pmList[i].getDictionaries();
            while (configs.hasMoreElements()) {
                Object boundLocation;
                Dictionary config = (Dictionary)configs.nextElement();
                String pid = (String)config.get("service.pid");
                if (pid == null || unprivileged && !location.equals(boundLocation = config.get("service.bundleLocation")) || filter != null && !filter.match(config)) continue;
                ConfigurationImpl cfg = this.getCachedConfiguration(pid);
                if (cfg == null) {
                    cfg = new ConfigurationImpl(this, pmList[i], config);
                }
                if (cfg.isNew()) continue;
                configList.add(cfg);
            }
        }
        return configList.toArray(new ConfigurationImpl[configList.size()]);
    }

    void deleted(ConfigurationImpl config) {
        this.removeConfiguration(config);
        this.fireConfigurationEvent(2, config.getPid(), config.getFactoryPid());
        this.updateThread.schedule(new DeleteConfiguration(config));
        if (this.isLogEnabled(4)) {
            this.log(4, "DeleteConfiguration(" + config.getPid() + ") scheduled", null);
        }
    }

    void updated(ConfigurationImpl config, boolean fireEvent) {
        if (fireEvent) {
            this.fireConfigurationEvent(1, config.getPid(), config.getFactoryPid());
        }
        this.updateThread.schedule(new UpdateConfiguration(config));
        if (this.isLogEnabled(4)) {
            this.log(4, "UpdateConfiguration(" + config.getPid() + ") scheduled", null);
        }
    }

    void fireConfigurationEvent(int type, String pid, String factoryPid) {
        FireConfigurationEvent event = new FireConfigurationEvent(type, pid, factoryPid);
        if (event.hasConfigurationEventListeners()) {
            this.eventThread.schedule(event);
        } else if (this.isLogEnabled(4)) {
            this.log(4, "No ConfigurationListeners to send " + event.getTypeName() + " event to.", null);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 && this.handleBundleEvents) {
            String location = event.getBundle().getLocation();
            ConfigurationImpl[] configs = this.getCachedConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationImpl cfg = configs[i];
                if (!location.equals(cfg.getDynamicBundleLocation())) continue;
                cfg.setDynamicBundleLocation(null);
            }
            Factory[] factories = this.getCachedFactories();
            for (int i = 0; i < factories.length; ++i) {
                Factory factory = factories[i];
                if (!location.equals(factory.getDynamicBundleLocation())) continue;
                factory.setDynamicBundleLocation(null);
            }
        }
    }

    private PersistenceManager[] getPersistenceManagers() {
        int currentPmtCount = this.persistenceManagerTracker.getTrackingCount();
        if (this.persistenceManagers == null || currentPmtCount > this.pmtCount) {
            PersistenceManager[] pm;
            ArrayList<CachingPersistenceManagerProxy> pmList = new ArrayList<CachingPersistenceManagerProxy>();
            ServiceReference[] refs = this.persistenceManagerTracker.getServiceReferences();
            if (refs == null || refs.length == 0) {
                pm = new PersistenceManager[]{};
            } else {
                TreeSet<ServiceReference> pms = new TreeSet<ServiceReference>(new RankingComparator(false));
                for (int i = 0; i < refs.length; ++i) {
                    pms.add(refs[i]);
                }
                int pmIndex = 0;
                for (ServiceReference ref : pms) {
                    Object service = this.persistenceManagerTracker.getService(ref);
                    if (service != null) {
                        pmList.add(new CachingPersistenceManagerProxy((PersistenceManager)service));
                    }
                    ++pmIndex;
                }
                pm = pmList.toArray(new PersistenceManager[pmList.size()]);
            }
            this.pmtCount = pm.length;
            this.persistenceManagers = pm;
        }
        return this.persistenceManagers;
    }

    private ServiceReference getServiceReference() {
        ServiceRegistration reg = this.configurationAdminRegistration;
        return reg != null ? reg.getReference() : null;
    }

    private void configure(ServiceReference sr, ManagedService service) {
        String[] pids = ConfigurationManager.getServicePid(sr);
        if (pids != null) {
            for (int i = 0; i < pids.length; ++i) {
                ManagedServiceUpdate update = new ManagedServiceUpdate(pids[i], sr, service);
                this.updateThread.schedule(update);
                if (!this.isLogEnabled(4)) continue;
                this.log(4, "ManagedServiceUpdate(" + pids[i] + ") scheduled", null);
            }
        }
    }

    private void configure(ServiceReference sr, ManagedServiceFactory service) {
        String[] pids = ConfigurationManager.getServicePid(sr);
        if (pids != null) {
            for (int i = 0; i < pids.length; ++i) {
                ManagedServiceFactoryUpdate update = new ManagedServiceFactoryUpdate(pids[i], sr, service);
                this.updateThread.schedule(update);
                if (!this.isLogEnabled(4)) continue;
                this.log(4, "ManagedServiceFactoryUpdate(" + pids[i] + ") scheduled", null);
            }
        }
    }

    ConfigurationImpl createConfiguration(String pid, String factoryPid, String bundleLocation) throws IOException {
        return new ConfigurationImpl(this, this.getPersistenceManagers()[0], pid, factoryPid, bundleLocation);
    }

    Factory getFactory(String factoryPid) throws IOException {
        Factory factory = this.getCachedFactory(factoryPid);
        if (factory != null) {
            return factory;
        }
        PersistenceManager[] pmList = this.getPersistenceManagers();
        for (int i = 0; i < pmList.length; ++i) {
            if (!Factory.exists(pmList[i], factoryPid)) continue;
            factory = Factory.load(this, pmList[i], factoryPid);
            this.cacheFactory(factory);
            return factory;
        }
        return this.createFactory(factoryPid);
    }

    Factory createFactory(String factoryPid) {
        Factory factory = new Factory(this, this.getPersistenceManagers()[0], factoryPid);
        this.cacheFactory(factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPlugins(Dictionary props, String targetPid, ServiceReference sr, ConfigurationImpl cfg) {
        if (props == null) {
            return;
        }
        ServiceReference[] plugins = null;
        try {
            String filter = "(|(!(cm.target=*))(cm.target=" + targetPid + "))";
            plugins = this.bundleContext.getServiceReferences(ConfigurationPlugin.class.getName(), filter);
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return;
        }
        TreeSet<ServiceReference> pluginSet = new TreeSet<ServiceReference>(cmRankComp);
        for (int i = 0; i < plugins.length; ++i) {
            pluginSet.add(plugins[i]);
        }
        for (ServiceReference pluginRef : pluginSet) {
            ConfigurationPlugin plugin = (ConfigurationPlugin)this.bundleContext.getService(pluginRef);
            try {
                plugin.modifyConfiguration(sr, props);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem calling configuration plugin " + ConfigurationManager.toString(pluginRef), t);
            }
            finally {
                this.bundleContext.ungetService(pluginRef);
            }
            cfg.setAutoProperties(props, false);
        }
    }

    private static String createPid(String factoryPid) {
        Random ng = numberGenerator;
        if (ng == null) {
            try {
                ng = new SecureRandom();
            }
            catch (Throwable t) {
                ng = new Random();
            }
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        StringBuffer buf = new StringBuffer(factoryPid.length() + 1 + 36);
        buf.append(factoryPid).append(".");
        for (int i = 0; i < randomBytes.length; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buf.append('-');
            }
            int val = randomBytes[i] & 0xFF;
            buf.append(Integer.toHexString(val >> 4));
            buf.append(Integer.toHexString(val & 0xF));
        }
        return buf.toString();
    }

    boolean isLogEnabled(int level) {
        return level <= this.logLevel;
    }

    void log(int level, String message, Throwable t) {
        Object log = this.logTracker.getService();
        if (log != null) {
            ((LogService)log).log(this.getServiceReference(), level, message, t);
            return;
        }
        if (this.isLogEnabled(level)) {
            String code;
            switch (level) {
                case 3: {
                    code = "*INFO *";
                    break;
                }
                case 2: {
                    code = "*WARN *";
                    break;
                }
                case 1: {
                    code = "*ERROR*";
                    break;
                }
                default: {
                    code = "*DEBUG*";
                }
            }
            System.err.println(code + " " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    static String[] getServicePid(ServiceReference reference) {
        Object pidObj = reference.getProperty("service.pid");
        if (pidObj instanceof String) {
            return new String[]{(String)pidObj};
        }
        if (pidObj instanceof String[]) {
            return (String[])pidObj;
        }
        if (pidObj instanceof Collection) {
            Collection pidCollection = (Collection)pidObj;
            return pidCollection.toArray(new String[pidCollection.size()]);
        }
        return null;
    }

    static String toString(ServiceReference ref) {
        String[] ocs = (String[])ref.getProperty("objectClass");
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < ocs.length; ++i) {
            buf.append(ocs[i]);
            if (i >= ocs.length - 1) continue;
            buf.append(", ");
        }
        buf.append(", id=").append(ref.getProperty("service.id"));
        Bundle provider = ref.getBundle();
        if (provider != null) {
            buf.append(", bundle=").append(provider.getBundleId());
        } else {
            buf.append(", unregistered");
        }
        buf.append("]");
        return buf.toString();
    }

    void handleCallBackError(Throwable error, ServiceReference target, ConfigurationImpl config) {
        if (error instanceof ConfigurationException) {
            ConfigurationException ce = (ConfigurationException)error;
            if (ce.getProperty() != null) {
                this.log(1, ConfigurationManager.toString(target) + ": Updating configuration property " + ce.getProperty() + " caused a problem: " + ce.getReason(), ce);
            } else {
                this.log(1, ConfigurationManager.toString(target) + ": Updating configuration caused a problem: " + ce.getReason(), ce);
            }
        } else {
            this.log(1, ConfigurationManager.toString(target) + ": Unexpected problem updating " + config, error);
        }
    }

    void callManagedService(Bundle bundle, final ManagedService srv, final Dictionary props) throws ConfigurationException {
        if (this.executorServiceFinder == null) {
            srv.updated(props);
        } else {
            this.executorServiceFinder.find(bundle).submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    srv.updated(props);
                    return null;
                }
            });
        }
    }

    void callManagedServiceFactoryUpdated(Bundle bundle, final ManagedServiceFactory srv, final String pid, final Dictionary props) throws ConfigurationException {
        if (this.executorServiceFinder == null) {
            srv.updated(pid, props);
        } else {
            this.executorServiceFinder.find(bundle).submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    srv.updated(pid, props);
                    return null;
                }
            });
        }
    }

    void callManagedServiceFactoryDeleted(Bundle bundle, final ManagedServiceFactory srv, final String pid) throws ConfigurationException {
        if (this.executorServiceFinder == null) {
            srv.deleted(pid);
        } else {
            this.executorServiceFinder.find(bundle).submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    srv.deleted(pid);
                    return null;
                }
            });
        }
    }

    static {
        cmRankComp = new RankingComparator(true, "service.cmRanking");
    }

    private static class ManagedServiceFactoryTracker
    extends ServiceTracker {
        private final ConfigurationManager cm;

        ManagedServiceFactoryTracker(ConfigurationManager cm) {
            super(cm.bundleContext, ManagedServiceFactory.class.getName(), null);
            this.cm = cm;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            Object serviceObject = super.addingService(reference);
            if (serviceObject instanceof ManagedServiceFactory) {
                this.cm.configure(reference, (ManagedServiceFactory)serviceObject);
            } else {
                this.cm.log(2, "Service " + serviceObject + " is not a ManagedServiceFactory", null);
            }
            return serviceObject;
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] factoryPids = ConfigurationManager.getServicePid(reference);
            if (factoryPids != null) {
                for (int i = 0; i < factoryPids.length; ++i) {
                    Factory factory = this.cm.getCachedFactory(factoryPids[i]);
                    if (factory == null) continue;
                    for (String pid : factory.getPIDs()) {
                        ConfigurationImpl cfg = this.cm.getCachedConfiguration(pid);
                        if (cfg == null || !reference.equals(cfg.getServiceReference())) continue;
                        cfg.setServiceReference(null);
                    }
                }
            }
            super.removedService(reference, service);
        }
    }

    private static class ManagedServiceTracker
    extends ServiceTracker {
        private final ConfigurationManager cm;

        ManagedServiceTracker(ConfigurationManager cm) {
            super(cm.bundleContext, ManagedService.class.getName(), null);
            this.cm = cm;
            this.open();
        }

        public Object addingService(ServiceReference reference) {
            Object serviceObject = super.addingService(reference);
            if (serviceObject instanceof ManagedService) {
                this.cm.configure(reference, (ManagedService)serviceObject);
            } else {
                this.cm.log(2, "Service " + serviceObject + " is not a ManagedService", null);
            }
            return serviceObject;
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] pids = ConfigurationManager.getServicePid(reference);
            if (pids != null) {
                for (int i = 0; i < pids.length; ++i) {
                    ConfigurationImpl cfg = this.cm.getCachedConfiguration(pids[i]);
                    if (cfg == null || !reference.equals(cfg.getServiceReference())) continue;
                    cfg.setServiceReference(null);
                }
            }
            super.removedService(reference, service);
        }
    }

    private class FireConfigurationEvent
    implements Runnable {
        private final int type;
        private final String pid;
        private final String factoryPid;
        private final ServiceReference[] listenerReferences;
        private final ConfigurationListener[] listeners;
        private final Bundle[] listenerProvider;
        private final Subject subject;

        private FireConfigurationEvent(int type, String pid, String factoryPid) {
            this.type = type;
            this.pid = pid;
            this.factoryPid = factoryPid;
            this.subject = Subject.getSubject(AccessController.getContext());
            ServiceReference[] srs = ConfigurationManager.this.configurationListenerTracker.getServiceReferences();
            if (srs == null || srs.length == 0) {
                this.listenerReferences = null;
                this.listeners = null;
                this.listenerProvider = null;
            } else {
                this.listenerReferences = srs;
                this.listeners = new ConfigurationListener[srs.length];
                this.listenerProvider = new Bundle[srs.length];
                for (int i = 0; i < srs.length; ++i) {
                    this.listeners[i] = (ConfigurationListener)ConfigurationManager.this.configurationListenerTracker.getService(srs[i]);
                    this.listenerProvider[i] = srs[i].getBundle();
                }
            }
        }

        boolean hasConfigurationEventListeners() {
            return this.listenerReferences != null;
        }

        String getTypeName() {
            switch (this.type) {
                case 2: {
                    return "CM_DELETED";
                }
                case 1: {
                    return "CM_UPDATED";
                }
            }
            return "<UNKNOWN(" + this.type + ")>";
        }

        public void run() {
            if (this.subject != null) {
                Subject.doAs(this.subject, new PrivilegedAction(){

                    public Object run() {
                        FireConfigurationEvent.this.doRun();
                        return null;
                    }
                });
            } else {
                this.doRun();
            }
        }

        private void doRun() {
            String typeName = this.getTypeName();
            ConfigurationEvent event = new ConfigurationEvent(ConfigurationManager.this.getServiceReference(), this.type, this.factoryPid, this.pid);
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listenerProvider[i].getState() != 32) continue;
                if (ConfigurationManager.this.isLogEnabled(4)) {
                    ConfigurationManager.this.log(4, "Sending " + typeName + " event for " + this.pid + " to " + ConfigurationManager.toString(this.listenerReferences[i]), null);
                }
                try {
                    this.listeners[i].configurationEvent(event);
                    continue;
                }
                catch (Throwable t) {
                    ConfigurationManager.this.log(1, "Unexpected problem delivery configuration event to " + ConfigurationManager.toString(this.listenerReferences[i]), t);
                }
            }
        }

        public String toString() {
            return "Fire ConfigurationEvent: pid=" + this.pid;
        }
    }

    private class DeleteConfiguration
    implements Runnable {
        private final ConfigurationImpl config;
        private final String configLocation;

        DeleteConfiguration(ConfigurationImpl config) {
            this.config = config;
            this.configLocation = config.getBoundBundleLocation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block19: {
                String pid = this.config.getPid();
                String factoryPid = this.config.getFactoryPid();
                try {
                    if (factoryPid == null) {
                        ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences(ManagedService.class.getName(), "(service.pid=" + pid + ")");
                        if (srList != null) {
                            for (int i = 0; i < srList.length; ++i) {
                                ServiceReference sr = srList[i];
                                if (!sr.getBundle().getLocation().equals(this.configLocation)) continue;
                                ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(sr);
                                try {
                                    ConfigurationManager.this.callManagedService(sr.getBundle(), srv, null);
                                    continue;
                                }
                                catch (Throwable t) {
                                    ConfigurationManager.this.handleCallBackError(t, sr, this.config);
                                    continue;
                                }
                                finally {
                                    ConfigurationManager.this.bundleContext.ungetService(sr);
                                }
                            }
                        }
                        break block19;
                    }
                    try {
                        Factory factory = ConfigurationManager.this.getFactory(factoryPid);
                        factory.removePID(pid);
                        factory.store();
                    }
                    catch (IOException ioe) {
                        ConfigurationManager.this.log(1, "Failed removing " + pid + " from the factory " + factoryPid, ioe);
                    }
                    ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences(ManagedServiceFactory.class.getName(), "(service.pid=" + factoryPid + ")");
                    if (srList != null) {
                        for (int i = 0; i < srList.length; ++i) {
                            ServiceReference sr = srList[i];
                            if (!sr.getBundle().getLocation().equals(this.configLocation)) continue;
                            ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(sr);
                            try {
                                ConfigurationManager.this.callManagedServiceFactoryDeleted(sr.getBundle(), srv, pid);
                                continue;
                            }
                            catch (Throwable t) {
                                ConfigurationManager.this.handleCallBackError(t, sr, this.config);
                                continue;
                            }
                            finally {
                                ConfigurationManager.this.bundleContext.ungetService(sr);
                            }
                        }
                    }
                }
                catch (InvalidSyntaxException ise) {
                    ConfigurationManager.this.log(1, "Service selection filter is invalid to update " + this.config, ise);
                }
            }
        }

        public String toString() {
            return "Delete: pid=" + this.config.getPid();
        }
    }

    class FelixExecutorServiceFinder
    implements ExecutorServiceFinder {
        ServiceReference sr;

        FelixExecutorServiceFinder() {
            this.sr = ConfigurationManager.this.bundleContext.getServiceReference(MonitoringService.class.getName());
            if (this.sr == null) {
                throw new UnsupportedOperationException();
            }
        }

        public ExecutorService find(Bundle bundle) {
            return ((MonitoringService)ConfigurationManager.this.bundleContext.getService(this.sr)).getExecutor(bundle);
        }
    }

    static interface ExecutorServiceFinder {
        public ExecutorService find(Bundle var1);
    }

    private class UpdateConfiguration
    implements Runnable {
        private final ConfigurationImpl config;
        private final Dictionary properties;
        private final long lastModificationTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UpdateConfiguration(ConfigurationImpl config) {
            this.config = config;
            ConfigurationImpl configurationImpl = config;
            synchronized (configurationImpl) {
                Hashtable props = config.getProperties(true);
                if (props == null) {
                    props = new Hashtable();
                }
                this.properties = props;
                this.lastModificationTime = config.getLastModificationTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block26: {
                try {
                    String bundleLocation;
                    if (this.lastModificationTime <= this.config.getLastUpdatedTime()) {
                        if (ConfigurationManager.this.isLogEnabled(4)) {
                            ConfigurationManager.this.log(4, "Configuration " + this.config.getPid() + " at modification #" + this.config.getLastModificationTime() + " has already been updated to update #" + this.config.getLastUpdatedTime() + ", nothing to be done anymore.", null);
                        }
                        return;
                    }
                    if (ConfigurationManager.this.isLogEnabled(4)) {
                        ConfigurationManager.this.log(4, "Updating configuration " + this.config.getPid() + " to modification #" + this.config.getLastModificationTime(), null);
                    }
                    if (this.config.getFactoryPid() == null) {
                        String bundleLocation2;
                        ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences(ManagedService.class.getName(), "(service.pid=" + this.config.getPid() + ")");
                        if (srList == null) break block26;
                        ServiceReference ownerRef = this.getOwner(this.config, srList);
                        String string = bundleLocation2 = ownerRef != null ? ownerRef.getBundle().getLocation() : this.config.getBoundBundleLocation();
                        if (this.config.getBundleLocation() == null) {
                            this.config.setDynamicBundleLocation(bundleLocation2);
                        }
                        String configBundleLocation = this.config.getBundleLocation();
                        for (int i = 0; i < srList.length; ++i) {
                            ServiceReference userRef = srList[i];
                            String userRefLocation = userRef.getBundle().getLocation();
                            if (!userRefLocation.equals(configBundleLocation)) {
                                ConfigurationManager.this.log(1, "Cannot use configuration " + this.config.getPid() + " for " + ConfigurationManager.toString(userRef) + ": Configuration bound to bundle " + configBundleLocation, null);
                                continue;
                            }
                            if (userRef != ownerRef) {
                                ConfigurationManager.this.log(1, "Configuration for " + this.config.getPid() + " has already been used for service " + ConfigurationManager.toString(ownerRef) + " and will now also be given to " + ConfigurationManager.toString(userRef), null);
                            }
                            try {
                                ManagedService srv = (ManagedService)ConfigurationManager.this.bundleContext.getService(userRef);
                                if (srv != null) {
                                    CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties);
                                    ConfigurationManager.this.callPlugins(props, this.config.getPid(), userRef, this.config);
                                    ConfigurationManager.this.callManagedService(userRef.getBundle(), srv, props);
                                }
                            }
                            catch (Throwable t) {
                                ConfigurationManager.this.handleCallBackError(t, userRef, this.config);
                            }
                            finally {
                                ConfigurationManager.this.bundleContext.ungetService(userRef);
                            }
                            this.config.setLastUpdatedTime(this.lastModificationTime);
                            if (!ConfigurationManager.this.isLogEnabled(4)) continue;
                            ConfigurationManager.this.log(4, "Updated configuration " + this.config.getPid() + " to update #" + this.config.getLastUpdatedTime(), null);
                        }
                        break block26;
                    }
                    ServiceReference[] srList = ConfigurationManager.this.bundleContext.getServiceReferences(ManagedServiceFactory.class.getName(), "(service.pid=" + this.config.getFactoryPid() + ")");
                    if (srList == null || srList.length <= 0) break block26;
                    ServiceReference ownerRef = this.getOwner(this.config, srList);
                    String string = bundleLocation = ownerRef != null ? ownerRef.getBundle().getLocation() : this.config.getBoundBundleLocation();
                    if (this.config.getBundleLocation() == null) {
                        this.config.setDynamicBundleLocation(bundleLocation);
                    }
                    String configBundleLocation = this.config.getBundleLocation();
                    for (int i = 0; i < srList.length; ++i) {
                        ServiceReference ref = srList[i];
                        String refLocation = ref.getBundle().getLocation();
                        if (!refLocation.equals(configBundleLocation)) {
                            ConfigurationManager.this.log(1, "Cannot use configuration " + this.config.getPid() + " (factory " + this.config.getFactoryPid() + ") for " + ConfigurationManager.toString(ref) + ": Configuration bound to bundle " + configBundleLocation, null);
                            continue;
                        }
                        if (ref != ownerRef) {
                            ConfigurationManager.this.log(1, "Configuration for " + this.config.getPid() + " (factory " + this.config.getFactoryPid() + ") has already been used for service " + ConfigurationManager.toString(ownerRef) + " and will now also be given to " + ConfigurationManager.toString(ref), null);
                        }
                        try {
                            ManagedServiceFactory srv = (ManagedServiceFactory)ConfigurationManager.this.bundleContext.getService(ref);
                            if (srv != null) {
                                CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties);
                                ConfigurationManager.this.callPlugins(props, this.config.getFactoryPid(), ref, this.config);
                                ConfigurationManager.this.callManagedServiceFactoryUpdated(ref.getBundle(), srv, this.config.getPid(), props);
                            }
                        }
                        catch (Throwable t) {
                            ConfigurationManager.this.handleCallBackError(t, ref, this.config);
                        }
                        finally {
                            ConfigurationManager.this.bundleContext.ungetService(ref);
                        }
                        this.config.setLastUpdatedTime(this.lastModificationTime);
                        if (!ConfigurationManager.this.isLogEnabled(4)) continue;
                        ConfigurationManager.this.log(4, "Updated configuration " + this.config.getPid() + " to update #" + this.config.getLastUpdatedTime(), null);
                    }
                }
                catch (InvalidSyntaxException ise) {
                    ConfigurationManager.this.log(1, "Service selection filter is invalid to update " + this.config, ise);
                }
            }
        }

        private ServiceReference getOwner(ConfigurationImpl config, ServiceReference[] srList) {
            String configLocation;
            if (config.getServiceReference() != null) {
                for (int i = 0; i < srList.length; ++i) {
                    if (!srList[i].equals(config.getServiceReference())) continue;
                    return srList[i];
                }
            }
            if ((configLocation = config.getBoundBundleLocation()) != null) {
                for (int i = 0; i < srList.length; ++i) {
                    if (!configLocation.equals(srList[i].getBundle().getLocation())) continue;
                    return srList[i];
                }
                return null;
            }
            ServiceReference ownerRef = srList[0];
            config.setServiceReference(ownerRef);
            return ownerRef;
        }

        public String toString() {
            return "Update: pid=" + this.config.getPid();
        }
    }

    private class ManagedServiceFactoryUpdate
    implements Runnable {
        private final String factoryPid;
        private final ServiceReference sr;
        private final ManagedServiceFactory service;
        private final Factory factory;
        private final Map configs;
        private final Map stamps;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ManagedServiceFactoryUpdate(String factoryPid, ServiceReference sr, ManagedServiceFactory service) {
            HashMap<ConfigurationImpl, Long> stamps;
            HashMap<ConfigurationImpl, Dictionary> configs;
            Factory factory;
            block10: {
                this.factoryPid = factoryPid;
                this.sr = sr;
                this.service = service;
                factory = null;
                configs = null;
                stamps = null;
                try {
                    factory = ConfigurationManager.this.getFactory(factoryPid);
                    if (factory == null) break block10;
                    configs = new HashMap<ConfigurationImpl, Dictionary>();
                    stamps = new HashMap<ConfigurationImpl, Long>();
                    for (String pid : factory.getPIDs()) {
                        ConfigurationImpl cfg;
                        try {
                            cfg = ConfigurationManager.this.getExistingConfiguration(pid);
                        }
                        catch (IOException ioe) {
                            ConfigurationManager.this.log(1, "Error loading configuration for " + pid, ioe);
                            continue;
                        }
                        if (cfg == null) {
                            ConfigurationManager.this.log(1, "Configuration " + pid + " referred to by factory " + factoryPid + " does not exist", null);
                            factory.removePID(pid);
                            factory.storeSilently();
                            continue;
                        }
                        if (cfg.isNew()) {
                            ConfigurationManager.this.log(1, "Ignoring new configuration pid=" + pid, null);
                            continue;
                        }
                        if (!factoryPid.equals(cfg.getFactoryPid())) {
                            ConfigurationManager.this.log(1, "Configuration " + pid + " referred to by factory " + factoryPid + " seems to belong to factory " + cfg.getFactoryPid(), null);
                            factory.removePID(pid);
                            factory.storeSilently();
                            continue;
                        }
                        ConfigurationImpl configurationImpl = cfg;
                        synchronized (configurationImpl) {
                            configs.put(cfg, cfg.getProperties(true));
                            stamps.put(cfg, new Long(cfg.getLastModificationTime()));
                        }
                    }
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Cannot get factory mapping for factory PID " + factoryPid, ioe);
                }
            }
            this.factory = factory;
            this.configs = configs;
            this.stamps = stamps;
        }

        public void run() {
            Bundle serviceBundle = this.sr.getBundle();
            if (serviceBundle == null) {
                if (ConfigurationManager.this.isLogEnabled(3)) {
                    ConfigurationManager.this.log(3, "ManagedServiceFactory for factory PID " + this.factoryPid + " seems to already have been unregistered, not updating with factory", null);
                }
                return;
            }
            String serviceBundleLocation = serviceBundle.getLocation();
            if (!this.factory.tryBindLocation(serviceBundleLocation)) {
                ConfigurationManager.this.log(1, "Cannot use factory configuration " + this.factoryPid + " for " + ConfigurationManager.toString(this.sr) + ": Configuration bound to bundle " + this.factory.getBundleLocation(), null);
                return;
            }
            for (Map.Entry entry : this.configs.entrySet()) {
                ConfigurationImpl cfg = (ConfigurationImpl)entry.getKey();
                Dictionary properties = (Dictionary)entry.getValue();
                long lastModificationTime = (Long)this.stamps.get(cfg);
                if (lastModificationTime <= cfg.getLastUpdatedTime() && this.sr.equals(cfg.getServiceReference())) {
                    if (ConfigurationManager.this.isLogEnabled(4)) {
                        ConfigurationManager.this.log(4, "Configuration " + cfg.getPid() + " at modification #" + cfg.getLastModificationTime() + " has already been updated to update #" + cfg.getLastUpdatedTime() + ", nothing to be done anymore.", null);
                    }
                    return;
                }
                if (ConfigurationManager.this.isLogEnabled(4)) {
                    ConfigurationManager.this.log(4, "Updating configuration " + cfg.getPid() + " to modification #" + cfg.getLastModificationTime(), null);
                }
                if (!cfg.tryBindLocation(serviceBundleLocation)) {
                    ConfigurationManager.this.log(1, "Cannot use configuration " + cfg.getPid() + " (factory " + this.factoryPid + ") for " + ConfigurationManager.toString(this.sr) + ": Configuration bound to bundle " + cfg.getBundleLocation(), null);
                    continue;
                }
                if (cfg.getServiceReference() == null) {
                    cfg.setServiceReference(this.sr);
                } else if (!this.sr.equals(cfg.getServiceReference())) {
                    ConfigurationManager.this.log(1, "Configuration for " + cfg.getPid() + " (factory " + this.factoryPid + ") has already been used for service " + ConfigurationManager.toString(cfg.getServiceReference()) + " and will now also be given to " + ConfigurationManager.toString(this.sr), null);
                }
                ConfigurationManager.this.callPlugins(properties, this.factoryPid, this.sr, cfg);
                if (properties == null) continue;
                if (ConfigurationManager.this.isLogEnabled(4)) {
                    ConfigurationManager.this.log(4, this.sr + ": Updating configuration pid=" + cfg.getPid(), null);
                }
                try {
                    ConfigurationManager.this.callManagedServiceFactoryUpdated(this.sr.getBundle(), this.service, cfg.getPid(), properties);
                }
                catch (Throwable t) {
                    ConfigurationManager.this.handleCallBackError(t, this.sr, cfg);
                }
                cfg.setLastUpdatedTime(lastModificationTime);
                if (!ConfigurationManager.this.isLogEnabled(4)) continue;
                ConfigurationManager.this.log(4, "Updated configuration " + cfg.getPid() + " to update #" + cfg.getLastUpdatedTime(), null);
            }
        }

        public String toString() {
            return "ManagedServiceFactory Update: factoryPid=" + this.factoryPid;
        }
    }

    private class ManagedServiceUpdate
    implements Runnable {
        private final String pid;
        private final ServiceReference sr;
        private final ManagedService service;
        private final ConfigurationImpl config;
        private final Dictionary rawProperties;
        private final long lastModificationTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ManagedServiceUpdate(String pid, ServiceReference sr, ManagedService service) {
            long lastModificationTime;
            Dictionary rawProperties;
            ConfigurationImpl config;
            block5: {
                this.pid = pid;
                this.sr = sr;
                this.service = service;
                config = null;
                rawProperties = null;
                lastModificationTime = -1L;
                try {
                    config = ConfigurationManager.this.getExistingConfiguration(pid);
                    if (config == null) break block5;
                    ConfigurationImpl configurationImpl = config;
                    synchronized (configurationImpl) {
                        rawProperties = config.getProperties(true);
                        lastModificationTime = config.getLastModificationTime();
                    }
                }
                catch (IOException ioe) {
                    ConfigurationManager.this.log(1, "Error loading configuration for " + pid, ioe);
                }
            }
            this.config = config;
            this.rawProperties = rawProperties;
            this.lastModificationTime = lastModificationTime;
        }

        public void run() {
            Dictionary properties = this.rawProperties;
            if (properties != null && this.config != null && this.lastModificationTime <= this.config.getLastUpdatedTime() && this.sr.equals(this.config.getServiceReference())) {
                if (ConfigurationManager.this.isLogEnabled(4)) {
                    ConfigurationManager.this.log(4, "Configuration " + this.config.getPid() + " at modification #" + this.config.getLastModificationTime() + " has already been updated to update #" + this.config.getLastUpdatedTime() + ", nothing to be done anymore.", null);
                }
                return;
            }
            if (this.config != null) {
                Bundle serviceBundle;
                if (ConfigurationManager.this.isLogEnabled(4)) {
                    ConfigurationManager.this.log(4, "Updating configuration " + this.config.getPid() + " to modification #" + this.config.getLastModificationTime(), null);
                }
                if ((serviceBundle = this.sr.getBundle()) == null) {
                    if (ConfigurationManager.this.isLogEnabled(3)) {
                        ConfigurationManager.this.log(3, "Service for PID " + this.pid + " seems to already have been unregistered, not updating with configuration", null);
                    }
                    return;
                }
                if (!this.config.tryBindLocation(serviceBundle.getLocation())) {
                    ConfigurationManager.this.log(1, "Cannot use configuration " + this.pid + " for " + ConfigurationManager.toString(this.sr) + ": Configuration bound to bundle " + this.config.getBundleLocation(), null);
                    return;
                }
                if (this.config.getServiceReference() == null) {
                    this.config.setServiceReference(this.sr);
                } else if (!this.sr.equals(this.config.getServiceReference())) {
                    ConfigurationManager.this.log(1, "Configuration for " + this.pid + " has already been used for service " + ConfigurationManager.toString(this.config.getServiceReference()) + " and will now also be given to " + ConfigurationManager.toString(this.sr), null);
                }
                ConfigurationManager.this.callPlugins(properties, this.pid, this.sr, this.config);
            } else {
                properties = null;
            }
            try {
                ConfigurationManager.this.callManagedService(this.sr.getBundle(), this.service, properties);
            }
            catch (Throwable t) {
                ConfigurationManager.this.handleCallBackError(t, this.sr, this.config);
            }
            if (this.config != null && properties != null) {
                this.config.setLastUpdatedTime(this.lastModificationTime);
                if (ConfigurationManager.this.isLogEnabled(4)) {
                    ConfigurationManager.this.log(4, "Updated configuration " + this.config.getPid() + " to update #" + this.config.getLastUpdatedTime(), null);
                }
            }
        }

        public String toString() {
            return "ManagedService Update: pid=" + this.pid;
        }
    }
}

