/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.command;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.apache.karaf.diagnostic.core.common.DirectoryDumpDestination;
import org.apache.karaf.diagnostic.core.common.ZipDumpDestination;
import org.apache.karaf.shell.console.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="dev", name="create-dump", description="Creates zip archive wich diagnostic info.")
public class DumpCommand
extends OsgiCommandSupport {
    private List<DumpProvider> providers = new LinkedList<DumpProvider>();
    private SimpleDateFormat dumpFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
    @Option(name="-d", aliases={"--directory"}, description="Creates dump in directory instead ZIP")
    boolean directory;
    @Argument(name="name", description="Name of created zip or directory", required=false)
    String fileName;

    protected Object doExecute() throws Exception {
        if (this.providers.isEmpty()) {
            this.session.getConsole().println("Unable to create dump. No providers were found");
            return null;
        }
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.fileName = this.dumpFormat.format(new Date());
            if (!this.directory) {
                this.fileName = this.fileName + ".zip";
            }
        }
        File target = new File(this.fileName);
        Object destination = this.directory ? new DirectoryDumpDestination(target) : new ZipDumpDestination(target);
        for (DumpProvider provider : this.providers) {
            provider.createDump((DumpDestination)destination);
        }
        destination.save();
        this.session.getConsole().println("Diagnostic dump created.");
        return null;
    }

    public void setProviders(List<DumpProvider> providers) {
        this.providers = providers;
    }
}

