/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.BlueprintContainerAware;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="ssh", description="Connects to a remote SSH server")
public class SshAction
extends OsgiCommandSupport
implements BlueprintContainerAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Option(name="-l", aliases={"--username"}, description="The user name for remote login", required=false, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="The password for remote login", required=false, multiValued=false)
    private String password;
    @Option(name="-p", aliases={"--port"}, description="The port to use for SSH connection", required=false, multiValued=false)
    private int port = 22;
    @Argument(index=0, name="hostname", description="The host name to connect to via SSH", required=true, multiValued=false)
    private String hostname;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;
    private BlueprintContainer container;
    private ClientSession sshSession;
    private String sshClientId;

    public void setBlueprintContainer(BlueprintContainer container) {
        assert (container != null);
        this.container = container;
    }

    public void setSshClientId(String sshClientId) {
        this.sshClientId = sshClientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        System.out.println("Connecting to host " + this.hostname + " on port " + this.port);
        if (this.username == null || this.password == null) {
            this.log.debug("Prompting user for credentials");
            if (this.username == null) {
                this.username = this.readLine("Login: ");
            }
            if (this.password == null) {
                this.password = this.readLine("Password: ");
            }
        }
        SshClient client = (SshClient)this.container.getComponentInstance(this.sshClientId);
        this.log.debug("Created client: {}", (Object)client);
        client.start();
        try {
            ConnectFuture future = client.connect(this.hostname, this.port);
            future.await();
            this.sshSession = future.getSession();
            Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
            this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
            try {
                ClientChannel channel;
                System.out.println("Connected");
                this.sshSession.authPassword(this.username, this.password);
                int ret = this.sshSession.waitFor(14, 0L);
                if ((ret & 8) == 0) {
                    System.err.println("Authentication failed");
                    Object var5_5 = null;
                    return var5_5;
                }
                StringBuilder sb = new StringBuilder();
                if (this.command != null) {
                    for (String cmd : this.command) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(cmd);
                    }
                }
                if (sb.length() > 0) {
                    channel = this.sshSession.createChannel("exec", sb.append("\n").toString());
                    channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                } else {
                    channel = this.sshSession.createChannel("shell");
                    channel.setIn((InputStream)new NoCloseInputStream(System.in));
                    ((ChannelShell)channel).setupSensibleDefaultPty();
                }
                channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                channel.open();
                channel.waitFor(2, 0L);
            }
            finally {
                this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
                this.sshSession.close(false);
            }
        }
        finally {
            client.stop();
        }
        return null;
    }

    public String readLine(String msg) throws IOException {
        StringBuffer sb = new StringBuffer();
        System.err.print(msg);
        System.err.flush();
        while (true) {
            int c;
            if ((c = this.session.getKeyboard().read()) < 0) {
                return null;
            }
            System.err.print((char)c);
            if (c == 13 || c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }
}

