/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.utils.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Import {
    private final String packageName;
    private final VersionRange version;
    private final String value;

    protected Import(String value) {
        this.value = value;
        this.packageName = Import.extractPackageName(value);
        this.version = value.contains("version=") ? this.extractVersion(value) : VersionRange.ANY_VERSION;
    }

    private VersionRange extractVersion(String value) {
        int begin = value.indexOf("version=") + 8;
        int end = value.indexOf(";", begin);
        if (end < 0) {
            return VersionRange.parseVersionRange(this.unquote(value.substring(begin)));
        }
        return VersionRange.parseVersionRange(this.unquote(value.substring(begin, end)));
    }

    private String unquote(String string) {
        return string.replace("\"", "");
    }

    public String getPackage() {
        return this.packageName;
    }

    public VersionRange getVersion() {
        return this.version;
    }

    public String toString() {
        return this.value;
    }

    public static List<Import> parse(String value) {
        LinkedList<Import> imports = new LinkedList<Import>();
        for (String imp : Import.split(value)) {
            imports.add(new Import(imp));
        }
        return imports;
    }

    public static List<Import> parse(String importValue, String exportValue) {
        LinkedList<String> exports = new LinkedList<String>();
        for (String exp : Import.split(exportValue)) {
            exports.add(Import.extractPackageName(exp));
        }
        LinkedList<Import> imports = new LinkedList<Import>();
        for (Import imp : Import.parse(importValue)) {
            if (exports.contains(imp.getPackage())) continue;
            imports.add(imp);
        }
        return imports;
    }

    private static String extractPackageName(String value) {
        if (value.contains(";")) {
            return value.split(";")[0];
        }
        return value;
    }

    private static int quotes(String value) {
        return value.replaceAll("[^\"]", "").length();
    }

    private static List<String> split(String value) {
        LinkedList<String> result = new LinkedList<String>();
        String[] elements = value.split(",");
        for (int i = 0; i < elements.length; ++i) {
            if (Import.quotes(elements[i]) % 2 == 1) {
                result.add(elements[i] + "," + elements[++i]);
                continue;
            }
            result.add(elements[i]);
        }
        return result;
    }
}

