/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Candidates;
import org.apache.felix.framework.resolver.HostModule;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.HostedRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.resolver.WireImpl;
import org.apache.felix.framework.resolver.WireModuleImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
implements Resolver {
    private final Logger m_logger;
    private final List<Candidates> m_usesPermutations = new ArrayList<Candidates>();
    private final List<Candidates> m_importPermutations = new ArrayList<Candidates>();
    private Map<Capability, List<Capability>> m_packageSourcesCache = new HashMap<Capability, List<Capability>>();

    public ResolverImpl(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Module, List<Wire>> resolve(Resolver.ResolverState state, Module module, Set<Module> fragments) {
        Map<Module, List<Wire>> wireMap = new HashMap<Module, List<Wire>>();
        HashMap<Module, Packages> modulePkgMap = new HashMap<Module, Packages>();
        if (!module.isResolved()) {
            boolean retryFragments;
            do {
                retryFragments = false;
                try {
                    Candidates allCandidates = new Candidates(state, module);
                    for (Module fragment : fragments) {
                        try {
                            allCandidates.populate(state, fragment);
                        }
                        catch (ResolveException ex) {}
                    }
                    allCandidates.mergeFragments();
                    this.m_usesPermutations.add(allCandidates);
                    ResolveException rethrow = null;
                    Requirement hostReq = ResolverImpl.getHostRequirement(module);
                    Module target = module;
                    do {
                        rethrow = null;
                        modulePkgMap.clear();
                        this.m_packageSourcesCache.clear();
                        Candidates candidates = allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                        if (hostReq != null) {
                            target = ((Capability)allCandidates.getCandidates(hostReq).iterator().next()).getModule();
                        }
                        this.calculatePackageSpaces(allCandidates.getWrappedHost(target), allCandidates, modulePkgMap, new HashMap<Capability, List<Module>>(), new HashSet<Module>());
                        try {
                            this.checkPackageSpaceConsistency(false, allCandidates.getWrappedHost(target), allCandidates, modulePkgMap, new HashMap<Module, Object>());
                        }
                        catch (ResolveException ex) {
                            rethrow = ex;
                        }
                    } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                    if (rethrow != null) {
                        Module faultyModule = ResolverImpl.getActualModule(rethrow.getModule());
                        if (rethrow.getRequirement() instanceof HostedRequirement) {
                            faultyModule = ((HostedRequirement)rethrow.getRequirement()).getDeclaredRequirement().getModule();
                        }
                        if (fragments.remove(faultyModule)) {
                            retryFragments = true;
                            continue;
                        }
                        throw rethrow;
                    }
                    wireMap = ResolverImpl.populateWireMap(allCandidates.getWrappedHost(target), modulePkgMap, wireMap, allCandidates);
                }
                finally {
                    this.m_usesPermutations.clear();
                    this.m_importPermutations.clear();
                }
            } while (retryFragments);
        }
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Module, List<Wire>> resolve(Resolver.ResolverState state, Module module, String pkgName, Set<Module> fragments) {
        Candidates allCandidates = ResolverImpl.getDynamicImportCandidates(state, module, pkgName);
        if (allCandidates != null) {
            boolean retryFragments;
            Map<Module, List<Wire>> wireMap = new HashMap<Module, List<Wire>>();
            HashMap<Module, Packages> modulePkgMap = new HashMap<Module, Packages>();
            do {
                retryFragments = false;
                try {
                    for (Module fragment : fragments) {
                        try {
                            allCandidates.populate(state, fragment);
                        }
                        catch (ResolveException ex) {}
                    }
                    allCandidates.mergeFragments();
                    this.m_usesPermutations.add(allCandidates);
                    ResolveException rethrow = null;
                    do {
                        rethrow = null;
                        modulePkgMap.clear();
                        this.m_packageSourcesCache.clear();
                        allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                        this.calculatePackageSpaces(allCandidates.getWrappedHost(module), allCandidates, modulePkgMap, new HashMap<Capability, List<Module>>(), new HashSet<Module>());
                        try {
                            this.checkPackageSpaceConsistency(false, allCandidates.getWrappedHost(module), allCandidates, modulePkgMap, new HashMap<Module, Object>());
                        }
                        catch (ResolveException ex) {
                            rethrow = ex;
                        }
                    } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                    if (rethrow != null) {
                        Module faultyModule = ResolverImpl.getActualModule(rethrow.getModule());
                        if (rethrow.getRequirement() instanceof HostedRequirement) {
                            faultyModule = ((HostedRequirement)rethrow.getRequirement()).getDeclaredRequirement().getModule();
                        }
                        if (fragments.remove(faultyModule)) {
                            retryFragments = true;
                            continue;
                        }
                        throw rethrow;
                    }
                    Map<Module, List<Wire>> map = wireMap = ResolverImpl.populateDynamicWireMap(module, pkgName, modulePkgMap, wireMap, allCandidates);
                    return map;
                }
                finally {
                    this.m_usesPermutations.clear();
                    this.m_importPermutations.clear();
                }
            } while (retryFragments);
        }
        return null;
    }

    private static Capability getHostCapability(Module m) {
        for (Capability c : m.getCapabilities()) {
            if (!c.getNamespace().equals("host")) continue;
            return c;
        }
        return null;
    }

    private static Requirement getHostRequirement(Module m) {
        for (Requirement r : m.getRequirements()) {
            if (!r.getNamespace().equals("host")) continue;
            return r;
        }
        return null;
    }

    private static Candidates getDynamicImportCandidates(Resolver.ResolverState state, Module module, String pkgName) {
        if (!module.isResolved() || pkgName.length() == 0) {
            return null;
        }
        List<Requirement> dynamics = module.getDynamicRequirements();
        if (dynamics == null || dynamics.isEmpty()) {
            return null;
        }
        List<Capability> caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.size(); ++i) {
            if (!caps.get(i).getNamespace().equals("package") || !caps.get(i).getAttribute("package").getValue().equals(pkgName)) continue;
            return null;
        }
        List<Wire> wires = module.getWires();
        for (int i = 0; wires != null && i < wires.size(); ++i) {
            if (!wires.get(i).hasPackage(pkgName)) continue;
            return null;
        }
        List dirs = Collections.EMPTY_LIST;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(new Attribute("package", pkgName, false));
        RequirementImpl req = new RequirementImpl(module, "package", dirs, attrs);
        SortedSet<Capability> candidates = state.getCandidates(module, req, false);
        Requirement dynReq = null;
        for (int dynIdx = 0; candidates.size() > 0 && dynReq == null && dynIdx < dynamics.size(); ++dynIdx) {
            Iterator itCand = candidates.iterator();
            while (dynReq == null && itCand.hasNext()) {
                Capability cap = (Capability)itCand.next();
                if (!CapabilitySet.matches(cap, dynamics.get(dynIdx).getFilter())) continue;
                dynReq = dynamics.get(dynIdx);
            }
        }
        if (dynReq != null) {
            Iterator itCand = candidates.iterator();
            while (itCand.hasNext()) {
                Capability cap = (Capability)itCand.next();
                if (CapabilitySet.matches(cap, dynReq.getFilter())) continue;
                itCand.remove();
            }
        } else {
            candidates.clear();
        }
        Candidates allCandidates = null;
        if (candidates.size() > 0) {
            allCandidates = new Candidates(state, module, dynReq, candidates);
        }
        return allCandidates;
    }

    private void calculatePackageSpaces(Module module, Candidates allCandidates, Map<Module, Packages> modulePkgMap, Map<Capability, List<Module>> usesCycleMap, Set<Module> cycle) {
        int i;
        Capability cap;
        SortedSet<Capability> candCaps;
        if (cycle.contains(module)) {
            return;
        }
        cycle.add(module);
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Capability> caps = new ArrayList<Capability>();
        boolean isDynamicImport = false;
        if (module.isResolved()) {
            for (Wire wire : module.getWires()) {
                Capability c;
                Requirement r = wire.getRequirement();
                if (!r.getModule().equals(wire.getImporter())) {
                    r = new HostedRequirement(wire.getImporter(), r);
                }
                if (!(c = wire.getCapability()).getModule().equals(wire.getExporter())) {
                    c = new HostedCapability(wire.getExporter(), c);
                }
                reqs.add(r);
                caps.add(c);
            }
            for (Requirement req : module.getDynamicRequirements()) {
                candCaps = allCandidates.getCandidates(req);
                if (candCaps == null) continue;
                cap = (Capability)candCaps.iterator().next();
                reqs.add(req);
                caps.add(cap);
                isDynamicImport = true;
                break;
            }
        } else {
            for (Requirement req : module.getRequirements()) {
                candCaps = allCandidates.getCandidates(req);
                if (candCaps == null) continue;
                cap = (Capability)candCaps.iterator().next();
                reqs.add(req);
                caps.add(cap);
            }
        }
        ResolverImpl.calculateExportedPackages(module, allCandidates, modulePkgMap);
        Packages modulePkgs = modulePkgMap.get(module);
        for (i = 0; i < reqs.size(); ++i) {
            Requirement req = (Requirement)reqs.get(i);
            cap = (Capability)caps.get(i);
            ResolverImpl.calculateExportedPackages(cap.getModule(), allCandidates, modulePkgMap);
            this.mergeCandidatePackages(module, req, cap, modulePkgMap, allCandidates);
        }
        for (i = 0; i < caps.size(); ++i) {
            this.calculatePackageSpaces(((Capability)caps.get(i)).getModule(), allCandidates, modulePkgMap, usesCycleMap, cycle);
        }
        if (!module.isResolved() || isDynamicImport) {
            ArrayList<Requirement> blameReqs;
            for (Map.Entry<String, List<Blame>> entry : modulePkgs.m_importedPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    if (blame.m_cap.getModule().equals(module)) continue;
                    blameReqs = new ArrayList<Requirement>();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(module, modulePkgs, blame.m_cap, blameReqs, modulePkgMap, allCandidates, usesCycleMap);
                }
            }
            for (Map.Entry<String, List<Blame>> entry : modulePkgs.m_requiredPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    blameReqs = new ArrayList();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(module, modulePkgs, blame.m_cap, blameReqs, modulePkgMap, allCandidates, usesCycleMap);
                }
            }
        }
    }

    private void mergeCandidatePackages(Module current, Requirement currentReq, Capability candCap, Map<Module, Packages> modulePkgMap, Candidates allCandidates) {
        if (candCap.getNamespace().equals("package")) {
            this.mergeCandidatePackage(current, false, currentReq, candCap, modulePkgMap);
        } else if (candCap.getNamespace().equals("module")) {
            ResolverImpl.calculateExportedPackages(candCap.getModule(), allCandidates, modulePkgMap);
            Packages candPkgs = modulePkgMap.get(candCap.getModule());
            for (Map.Entry<String, Blame> entry : candPkgs.m_exportedPkgs.entrySet()) {
                this.mergeCandidatePackage(current, true, currentReq, entry.getValue().m_cap, modulePkgMap);
            }
            for (Requirement req : candCap.getModule().getRequirements()) {
                Directive dir;
                if (!req.getNamespace().equals("module") || (dir = req.getDirective("visibility")) == null || !dir.getValue().equals("reexport") || allCandidates.getCandidates(req) == null) continue;
                this.mergeCandidatePackages(current, currentReq, (Capability)allCandidates.getCandidates(req).iterator().next(), modulePkgMap, allCandidates);
            }
        }
    }

    private void mergeCandidatePackage(Module current, boolean requires, Requirement currentReq, Capability candCap, Map<Module, Packages> modulePkgMap) {
        if (candCap.getNamespace().equals("package")) {
            String pkgName = (String)candCap.getAttribute("package").getValue();
            ArrayList<Requirement> blameReqs = new ArrayList<Requirement>();
            blameReqs.add(currentReq);
            Packages currentPkgs = modulePkgMap.get(current);
            if (requires) {
                List<Blame> currentRequiredBlames = currentPkgs.m_requiredPkgs.get(pkgName);
                if (currentRequiredBlames == null) {
                    currentRequiredBlames = new ArrayList<Blame>();
                    currentPkgs.m_requiredPkgs.put(pkgName, currentRequiredBlames);
                }
                currentRequiredBlames.add(new Blame(candCap, blameReqs));
            } else {
                List<Blame> currentImportedBlames = currentPkgs.m_importedPkgs.get(pkgName);
                if (currentImportedBlames == null) {
                    currentImportedBlames = new ArrayList<Blame>();
                    currentPkgs.m_importedPkgs.put(pkgName, currentImportedBlames);
                }
                currentImportedBlames.add(new Blame(candCap, blameReqs));
            }
        }
    }

    private void mergeUses(Module current, Packages currentPkgs, Capability mergeCap, List<Requirement> blameReqs, Map<Module, Packages> modulePkgMap, Candidates allCandidates, Map<Capability, List<Module>> cycleMap) {
        if (!mergeCap.getNamespace().equals("package")) {
            return;
        }
        if (current == mergeCap.getModule()) {
            return;
        }
        ArrayList<Module> list = cycleMap.get(mergeCap);
        if (list != null && list.contains(current)) {
            return;
        }
        list = list == null ? new ArrayList<Module>() : list;
        list.add(current);
        cycleMap.put(mergeCap, list);
        for (Capability candSourceCap : this.getPackageSources(mergeCap, modulePkgMap)) {
            for (String usedPkgName : candSourceCap.getUses()) {
                Packages candSourcePkgs = modulePkgMap.get(candSourceCap.getModule());
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                List<Object> candSourceBlames = null;
                if (candExportedBlame != null) {
                    candSourceBlames = new ArrayList<Blame>(1);
                    candSourceBlames.add(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_importedPkgs.get(usedPkgName);
                }
                if (candSourceBlames == null) continue;
                List<Blame> usedCaps = currentPkgs.m_usedPkgs.get(usedPkgName);
                if (usedCaps == null) {
                    usedCaps = new ArrayList<Blame>();
                    currentPkgs.m_usedPkgs.put(usedPkgName, usedCaps);
                }
                for (Blame blame : candSourceBlames) {
                    if (blame.m_reqs != null) {
                        ArrayList<Requirement> blameReqs2 = new ArrayList<Requirement>(blameReqs);
                        blameReqs2.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                        usedCaps.add(new Blame(blame.m_cap, blameReqs2));
                        this.mergeUses(current, currentPkgs, blame.m_cap, blameReqs2, modulePkgMap, allCandidates, cycleMap);
                        continue;
                    }
                    usedCaps.add(new Blame(blame.m_cap, blameReqs));
                    this.mergeUses(current, currentPkgs, blame.m_cap, blameReqs, modulePkgMap, allCandidates, cycleMap);
                }
            }
        }
    }

    private void checkPackageSpaceConsistency(boolean isDynamicImport, Module module, Candidates allCandidates, Map<Module, Packages> modulePkgMap, Map<Module, Object> resultCache) {
        if (module.isResolved() && !isDynamicImport) {
            return;
        }
        if (resultCache.containsKey(module)) {
            return;
        }
        Packages pkgs = modulePkgMap.get(module);
        ResolveException rethrow = null;
        Candidates permutation = null;
        Set mutated = null;
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Blame sourceBlame = null;
            for (Blame blame : entry.getValue()) {
                if (sourceBlame == null) {
                    sourceBlame = blame;
                    continue;
                }
                if (sourceBlame.m_cap.getModule().equals(blame.m_cap.getModule())) continue;
                ResolverImpl.permutate(allCandidates, blame.m_reqs.get(0), this.m_importPermutations);
                ResolverImpl.permutate(allCandidates, sourceBlame.m_reqs.get(0), this.m_importPermutations);
                ResolveException ex = new ResolveException(new StringBuffer().append("Unable to resolve module ").append(module.getSymbolicName()).append(" [").append(module).append("] because it is exposed to package '").append(entry.getKey()).append("' from ").append(sourceBlame.m_cap.getModule().getSymbolicName()).append(" [").append(sourceBlame.m_cap.getModule()).append("] and ").append(blame.m_cap.getModule().getSymbolicName()).append(" [").append(blame.m_cap.getModule()).append("] via two dependency chains.\n\nChain 1:\n").append(ResolverImpl.toStringBlame(sourceBlame)).append("\n\nChain 2:\n").append(ResolverImpl.toStringBlame(blame)).toString(), module, blame.m_reqs.get(0));
                this.m_logger.log(4, "Candidate permutation failed due to a conflict with a fragment import; will try another if possible.", ex);
                throw ex;
            }
        }
        for (Map.Entry<String, Object> entry : pkgs.m_exportedPkgs.entrySet()) {
            String pkgName = entry.getKey();
            Blame exportBlame = (Blame)entry.getValue();
            if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
            block5: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                Requirement req;
                if (this.isCompatible(exportBlame.m_cap, usedBlame.m_cap, modulePkgMap)) continue;
                permutation = permutation != null ? permutation : allCandidates.copy();
                rethrow = rethrow != null ? rethrow : new ResolveException(new StringBuffer().append("Unable to resolve module ").append(module.getSymbolicName()).append(" [").append(module).append("] because it exports package '").append(pkgName).append("' and is also exposed to it from ").append(usedBlame.m_cap.getModule().getSymbolicName()).append(" [").append(usedBlame.m_cap.getModule()).append("] via the following dependency chain:\n\n").append(ResolverImpl.toStringBlame(usedBlame)).toString(), null, null);
                mutated = mutated != null ? mutated : new HashSet();
                for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                    SortedSet<Capability> candidates = permutation.getCandidates(req);
                    if (candidates == null || candidates.size() <= 1) continue;
                    mutated.add(req);
                    Iterator it = candidates.iterator();
                    it.next();
                    it.remove();
                    continue block5;
                }
            }
            if (rethrow == null) continue;
            if (mutated.size() > 0) {
                this.m_usesPermutations.add(permutation);
            }
            this.m_logger.log(4, "Candidate permutation failed due to a conflict between an export and import; will try another if possible.", rethrow);
            throw rethrow;
        }
        for (Map.Entry<String, Object> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : (List)entry.getValue()) {
                Requirement req;
                String pkgName = entry.getKey();
                if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
                block9: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                    Requirement req2;
                    if (this.isCompatible(importBlame.m_cap, usedBlame.m_cap, modulePkgMap)) continue;
                    permutation = permutation != null ? permutation : allCandidates.copy();
                    rethrow = rethrow != null ? rethrow : new ResolveException(new StringBuffer().append("Unable to resolve module ").append(module.getSymbolicName()).append(" [").append(module).append("] because it is exposed to package '").append(pkgName).append("' from ").append(importBlame.m_cap.getModule().getSymbolicName()).append(" [").append(importBlame.m_cap.getModule()).append("] and ").append(usedBlame.m_cap.getModule().getSymbolicName()).append(" [").append(usedBlame.m_cap.getModule()).append("] via two dependency chains.\n\nChain 1:\n").append(ResolverImpl.toStringBlame(importBlame)).append("\n\nChain 2:\n").append(ResolverImpl.toStringBlame(usedBlame)).toString(), null, null);
                    mutated = mutated != null ? mutated : new HashSet();
                    for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req2 = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                        SortedSet<Capability> candidates = permutation.getCandidates(req2);
                        if (candidates == null || candidates.size() <= 1) continue;
                        mutated.add(req2);
                        Iterator it = candidates.iterator();
                        it.next();
                        it.remove();
                        continue block9;
                    }
                }
                if (rethrow == null) continue;
                if (mutated.size() > 0) {
                    this.m_usesPermutations.add(permutation);
                }
                if (!mutated.contains(req = importBlame.m_reqs.get(0))) {
                    ResolverImpl.permutateIfNeeded(allCandidates, req, this.m_importPermutations);
                }
                this.m_logger.log(4, "Candidate permutation failed due to a conflict between imports; will try another if possible.", rethrow);
                throw rethrow;
            }
        }
        resultCache.put(module, Boolean.TRUE);
        int permCount = this.m_usesPermutations.size() + this.m_importPermutations.size();
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : entry.getValue()) {
                if (module.equals(importBlame.m_cap.getModule())) continue;
                try {
                    this.checkPackageSpaceConsistency(false, importBlame.m_cap.getModule(), allCandidates, modulePkgMap, resultCache);
                }
                catch (ResolveException ex) {
                    if (permCount == this.m_usesPermutations.size() + this.m_importPermutations.size()) {
                        Requirement req = importBlame.m_reqs.get(0);
                        ResolverImpl.permutate(allCandidates, req, this.m_importPermutations);
                    }
                    throw ex;
                }
            }
        }
    }

    private static void permutate(Candidates allCandidates, Requirement req, List<Candidates> permutations) {
        SortedSet<Capability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            Candidates perm = allCandidates.copy();
            candidates = perm.getCandidates(req);
            Iterator it = candidates.iterator();
            it.next();
            it.remove();
            permutations.add(perm);
        }
    }

    private static void permutateIfNeeded(Candidates allCandidates, Requirement req, List<Candidates> permutations) {
        SortedSet<Capability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            boolean permutated = false;
            for (Candidates existingPerm : permutations) {
                SortedSet<Capability> existingPermCands = existingPerm.getCandidates(req);
                if (((Capability)existingPermCands.iterator().next()).equals(candidates.iterator().next())) continue;
                permutated = true;
            }
            if (!permutated) {
                ResolverImpl.permutate(allCandidates, req, permutations);
            }
        }
    }

    private static void calculateExportedPackages(Module module, Candidates allCandidates, Map<Module, Packages> modulePkgMap) {
        Packages packages = modulePkgMap.get(module);
        if (packages != null) {
            return;
        }
        packages = new Packages(module);
        HashMap<String, Capability> exports = new HashMap<String, Capability>(module.getCapabilities().size());
        for (Capability capability : module.getCapabilities()) {
            if (!capability.getNamespace().equals("package")) continue;
            exports.put((String)capability.getAttribute("package").getValue(), capability);
        }
        if (module.isResolved()) {
            for (Wire wire : module.getWires()) {
                if (!wire.getRequirement().getNamespace().equals("package")) continue;
                String pkgName = (String)wire.getCapability().getAttribute("package").getValue();
                exports.remove(pkgName);
            }
        } else {
            for (Requirement requirement : module.getRequirements()) {
                SortedSet<Capability> cands;
                if (!requirement.getNamespace().equals("package") || (cands = allCandidates.getCandidates(requirement)) == null || cands.isEmpty()) continue;
                String pkgName = (String)((Capability)cands.iterator().next()).getAttribute("package").getValue();
                exports.remove(pkgName);
            }
        }
        for (Map.Entry entry : exports.entrySet()) {
            packages.m_exportedPkgs.put((String)entry.getKey(), new Blame((Capability)entry.getValue(), null));
        }
        modulePkgMap.put(module, packages);
    }

    private boolean isCompatible(Capability currentCap, Capability candCap, Map<Module, Packages> modulePkgMap) {
        if (currentCap != null && candCap != null) {
            List<Capability> candSources;
            if (currentCap.equals(candCap)) {
                return true;
            }
            List<Capability> currentSources = this.getPackageSources(currentCap, modulePkgMap);
            return currentSources.containsAll(candSources = this.getPackageSources(candCap, modulePkgMap)) || candSources.containsAll(currentSources);
        }
        return true;
    }

    private List<Capability> getPackageSources(Capability cap, Map<Module, Packages> modulePkgMap) {
        if (cap.getNamespace().equals("package")) {
            List<Capability> sources = this.m_packageSourcesCache.get(cap);
            if (sources == null) {
                sources = ResolverImpl.getPackageSourcesInternal(cap, modulePkgMap, new ArrayList<Capability>(), new HashSet<Capability>());
                this.m_packageSourcesCache.put(cap, sources);
            }
            return sources;
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Capability> getPackageSourcesInternal(Capability cap, Map<Module, Packages> modulePkgMap, List<Capability> sources, Set<Capability> cycleMap) {
        if (cap.getNamespace().equals("package")) {
            if (cycleMap.contains(cap)) {
                return sources;
            }
            cycleMap.add(cap);
            String pkgName = cap.getAttribute("package").getValue().toString();
            List<Capability> caps = cap.getModule().getCapabilities();
            for (int capIdx = 0; capIdx < caps.size(); ++capIdx) {
                if (!caps.get(capIdx).getNamespace().equals("package") || !caps.get(capIdx).getAttribute("package").getValue().equals(pkgName)) continue;
                sources.add(caps.get(capIdx));
            }
            Packages pkgs = modulePkgMap.get(cap.getModule());
            List<Blame> required = pkgs.m_requiredPkgs.get(pkgName);
            if (required != null) {
                for (Blame blame : required) {
                    ResolverImpl.getPackageSourcesInternal(blame.m_cap, modulePkgMap, sources, cycleMap);
                }
            }
        }
        return sources;
    }

    private static Module getActualModule(Module m) {
        if (m instanceof HostModule) {
            return ((HostModule)m).getHost();
        }
        return m;
    }

    private static Capability getActualCapability(Capability c) {
        if (c instanceof HostedCapability) {
            return ((HostedCapability)c).getDeclaredCapability();
        }
        return c;
    }

    private static Requirement getActualRequirement(Requirement r) {
        if (r instanceof HostedRequirement) {
            return ((HostedRequirement)r).getDeclaredRequirement();
        }
        return r;
    }

    private static Map<Module, List<Wire>> populateWireMap(Module module, Map<Module, Packages> modulePkgMap, Map<Module, List<Wire>> wireMap, Candidates allCandidates) {
        Module unwrappedModule = ResolverImpl.getActualModule(module);
        if (!unwrappedModule.isResolved() && !wireMap.containsKey(unwrappedModule)) {
            wireMap.put(unwrappedModule, Collections.EMPTY_LIST);
            ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
            ArrayList<WireModuleImpl> moduleWires = new ArrayList<WireModuleImpl>();
            for (Requirement req : module.getRequirements()) {
                SortedSet<Capability> cands = allCandidates.getCandidates(req);
                if (cands == null || cands.size() <= 0) continue;
                Capability cand = (Capability)cands.iterator().next();
                if (!cand.getModule().isResolved()) {
                    ResolverImpl.populateWireMap(cand.getModule(), modulePkgMap, wireMap, allCandidates);
                }
                if (req.getNamespace().equals("package") && !module.equals(cand.getModule())) {
                    packageWires.add(new WireImpl(unwrappedModule, ResolverImpl.getActualRequirement(req), ResolverImpl.getActualModule(cand.getModule()), ResolverImpl.getActualCapability(cand)));
                    continue;
                }
                if (!req.getNamespace().equals("module")) continue;
                Packages candPkgs = modulePkgMap.get(cand.getModule());
                moduleWires.add(new WireModuleImpl(unwrappedModule, ResolverImpl.getActualRequirement(req), ResolverImpl.getActualModule(cand.getModule()), ResolverImpl.getActualCapability(cand), candPkgs.getExportedAndReexportedPackages()));
            }
            packageWires.addAll(moduleWires);
            wireMap.put(unwrappedModule, packageWires);
            if (module instanceof HostModule) {
                List<Module> fragments = ((HostModule)module).getFragments();
                for (Module fragment : fragments) {
                    List<Wire> hostWires = wireMap.get(fragment);
                    if (hostWires == null) {
                        hostWires = new ArrayList<Wire>();
                        wireMap.put(fragment, hostWires);
                    }
                    hostWires.add(new WireImpl(ResolverImpl.getActualModule(fragment), ResolverImpl.getHostRequirement(fragment), unwrappedModule, ResolverImpl.getHostCapability(unwrappedModule)));
                }
            }
        }
        return wireMap;
    }

    private static Map<Module, List<Wire>> populateDynamicWireMap(Module module, String pkgName, Map<Module, Packages> modulePkgMap, Map<Module, List<Wire>> wireMap, Candidates allCandidates) {
        wireMap.put(module, Collections.EMPTY_LIST);
        ArrayList<WireImpl> packageWires = new ArrayList<WireImpl>();
        Packages pkgs = modulePkgMap.get(module);
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame blame : entry.getValue()) {
                if (module.equals(blame.m_cap.getModule()) || !blame.m_cap.getAttribute("package").getValue().equals(pkgName)) continue;
                if (!blame.m_cap.getModule().isResolved()) {
                    ResolverImpl.populateWireMap(blame.m_cap.getModule(), modulePkgMap, wireMap, allCandidates);
                }
                ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                attrs.add(new Attribute("package", pkgName, false));
                packageWires.add(new WireImpl(module, new RequirementImpl(module, "package", new ArrayList<Directive>(0), attrs), ResolverImpl.getActualModule(blame.m_cap.getModule()), ResolverImpl.getActualCapability(blame.m_cap)));
            }
        }
        wireMap.put(module, packageWires);
        return wireMap;
    }

    private static void dumpModulePkgMap(Map<Module, Packages> modulePkgMap) {
        System.out.println("+++MODULE PKG MAP+++");
        for (Map.Entry<Module, Packages> entry : modulePkgMap.entrySet()) {
            ResolverImpl.dumpModulePkgs(entry.getKey(), entry.getValue());
        }
    }

    private static void dumpModulePkgs(Module module, Packages packages) {
        System.out.println(new StringBuffer().append(module).append(" (").append(module.isResolved() ? "RESOLVED)" : "UNRESOLVED)").toString());
        System.out.println("  EXPORTED");
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry<String, Object> entry : packages.m_importedPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry<String, Object> entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
        System.out.println("  USED");
        for (Map.Entry<String, Object> entry : packages.m_usedPkgs.entrySet()) {
            System.out.println(new StringBuffer().append("    ").append(entry.getKey()).append(" - ").append(entry.getValue()).toString());
        }
    }

    private static String toStringBlame(Blame blame) {
        StringBuffer sb = new StringBuffer();
        if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
            for (int i = 0; i < blame.m_reqs.size(); ++i) {
                Requirement req = blame.m_reqs.get(i);
                sb.append("  ");
                sb.append(req.getModule().getSymbolicName());
                sb.append(" [");
                sb.append(req.getModule().toString());
                sb.append("]\n");
                if (req.getNamespace().equals("package")) {
                    sb.append("    import: ");
                } else {
                    sb.append("    require: ");
                }
                sb.append(req.getFilter().toString());
                sb.append("\n     |");
                if (req.getNamespace().equals("package")) {
                    sb.append("\n    export: ");
                } else {
                    sb.append("\n    provide: ");
                }
                if (i + 1 < blame.m_reqs.size()) {
                    Capability cap = Util.getSatisfyingCapability(blame.m_reqs.get(i + 1).getModule(), blame.m_reqs.get(i));
                    if (cap.getNamespace().equals("package")) {
                        sb.append(cap.getAttribute("package").toString());
                        Capability usedCap = i + 2 < blame.m_reqs.size() ? Util.getSatisfyingCapability(blame.m_reqs.get(i + 2).getModule(), blame.m_reqs.get(i + 1)) : Util.getSatisfyingCapability(blame.m_cap.getModule(), blame.m_reqs.get(i + 1));
                        sb.append("; uses:=");
                        sb.append(usedCap.getAttribute("package").getValue());
                    } else {
                        sb.append(cap);
                    }
                    sb.append("\n");
                    continue;
                }
                Capability export = Util.getSatisfyingCapability(blame.m_cap.getModule(), blame.m_reqs.get(i));
                sb.append(export.getAttribute("package").toString());
                if (!export.getAttribute("package").getValue().equals(blame.m_cap.getAttribute("package").getValue())) {
                    sb.append("; uses:=");
                    sb.append(blame.m_cap.getAttribute("package").getValue());
                    sb.append("\n    export: ");
                    sb.append(blame.m_cap.getAttribute("package").toString());
                }
                sb.append("\n  ");
                sb.append(blame.m_cap.getModule().getSymbolicName());
                sb.append(" [");
                sb.append(blame.m_cap.getModule().toString());
                sb.append("]");
            }
        } else {
            sb.append(blame.m_cap.getModule().toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Blame {
        public final Capability m_cap;
        public final List<Requirement> m_reqs;

        public Blame(Capability cap, List<Requirement> reqs) {
            this.m_cap = cap;
            this.m_reqs = reqs;
        }

        public String toString() {
            return new StringBuffer().append(this.m_cap.getModule()).append(".").append(this.m_cap.getAttribute("package").getValue()).append(this.m_reqs == null || this.m_reqs.size() == 0 ? " NO BLAME" : new StringBuffer().append(" BLAMED ON ").append(this.m_reqs).toString()).toString();
        }

        public boolean equals(Object o) {
            return o instanceof Blame && ((Object)this.m_reqs).equals(((Blame)o).m_reqs) && this.m_cap.equals(((Blame)o).m_cap);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Packages {
        private final Module m_module;
        public final Map<String, Blame> m_exportedPkgs = new HashMap<String, Blame>();
        public final Map<String, List<Blame>> m_importedPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_requiredPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_usedPkgs = new HashMap<String, List<Blame>>();

        public Packages(Module module) {
            this.m_module = module;
        }

        public List<String> getExportedAndReexportedPackages() {
            ArrayList<String> pkgs = new ArrayList<String>();
            for (Capability capability : this.m_module.getCapabilities()) {
                if (!capability.getNamespace().equals("package")) continue;
                pkgs.add((String)capability.getAttribute("package").getValue());
            }
            block1: for (Map.Entry entry : this.m_requiredPkgs.entrySet()) {
                for (Blame blame : (List)entry.getValue()) {
                    Directive dir = blame.m_reqs.get(blame.m_reqs.size() - 1).getDirective("visibility");
                    if (dir == null || !dir.getValue().equals("reexport")) continue;
                    pkgs.add((String)blame.m_cap.getAttribute("package").getValue());
                    continue block1;
                }
            }
            return pkgs;
        }
    }
}

