/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.blueprint.BlueprintStateMBean;
import org.apache.aries.jmx.blueprint.codec.OSGiBlueprintEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintState
extends NotificationBroadcasterSupport
implements BlueprintStateMBean,
MBeanRegistration {
    public static String BLUEPRINT_EVENT = "org.osgi.blueprint.event";
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintState.class);
    private BundleContext context;
    private ServiceRegistration listenerReg;
    private Map<Long, CompositeData> dataMap = new HashMap<Long, CompositeData>();
    private ExecutorService eventDispatcher;
    private AtomicInteger notificationSequenceNumber = new AtomicInteger(1);
    private AtomicInteger registrations = new AtomicInteger(0);

    public BlueprintState(BundleContext context) {
        this.context = context;
    }

    public synchronized long[] getBlueprintBundleIds() throws IOException {
        Long[] bundleIdKeys = this.dataMap.keySet().toArray(new Long[this.dataMap.size()]);
        long[] bundleIds = new long[bundleIdKeys.length];
        for (int i = 0; i < bundleIdKeys.length; ++i) {
            bundleIds[i] = bundleIdKeys[i];
        }
        return bundleIds;
    }

    public synchronized CompositeData getLastEvent(long bundleId) throws IOException {
        return this.dataMap.get(bundleId);
    }

    public synchronized TabularData getLastEvents() throws IOException {
        TabularDataSupport table = new TabularDataSupport(BlueprintStateMBean.OSGI_BLUEPRINT_EVENTS_TYPE);
        table.putAll(this.dataMap);
        return table;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && this.registrations.incrementAndGet() == 1) {
            BlueprintStateListener listener = new BlueprintStateListener();
            this.eventDispatcher = Executors.newSingleThreadExecutor(new JMXThreadFactory("JMX OSGi Blueprint State Event Dispatcher"));
            this.listenerReg = this.context.registerService(BlueprintListener.class.getName(), (Object)listener, null);
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        if (this.registrations.decrementAndGet() < 1) {
            try {
                this.listenerReg.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.eventDispatcher != null) {
                this.eventDispatcher.shutdown();
            }
        }
    }

    protected synchronized void onEvent(BlueprintEvent event) {
        CompositeData data = new OSGiBlueprintEvent(event).asCompositeData();
        this.dataMap.put(event.getBundle().getBundleId(), data);
        if (!event.isReplay()) {
            final Notification notification = new Notification("EventType", "org.apache.aries.blueprint:service=blueprintState,version=1.0", this.notificationSequenceNumber.getAndIncrement());
            try {
                notification.setUserData(data);
                this.eventDispatcher.submit(new Runnable(){

                    public void run() {
                        BlueprintState.this.sendNotification(notification);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                LOGGER.warn("Task rejected for JMX Notification dispatch of event [" + event + "] - Dispatcher may have been shutdown");
            }
            catch (Exception e) {
                LOGGER.warn("Exception occured on JMX Notification dispatch for event [" + event + "]", (Throwable)e);
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{BLUEPRINT_EVENT};
        String name = Notification.class.getName();
        String description = "A BlueprintEvent issued from the Blueprint Extender describing a blueprint bundle lifecycle change";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public static class JMXThreadFactory
    implements ThreadFactory {
        private final ThreadFactory factory = Executors.defaultThreadFactory();
        private final String name;

        public JMXThreadFactory(String name) {
            this.name = name;
        }

        public Thread newThread(Runnable r) {
            Thread t = this.factory.newThread(r);
            t.setName(this.name);
            t.setDaemon(true);
            return t;
        }
    }

    private class BlueprintStateListener
    implements BlueprintListener {
        private BlueprintStateListener() {
        }

        public void blueprintEvent(BlueprintEvent event) {
            BlueprintState.this.onEvent(event);
        }
    }
}

