/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.filter;

import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public abstract class MatchFilterBase
extends Filter {
    public static final String ACCEPT_ON_MATCH = "AcceptOnMatch";
    public static final String DENY_ON_MATCH = "DenyOnMatch";
    public static final String ACCEPT_ON_NOMATCH = "AcceptOnNomatch";
    public static final String DENY_ON_NOMATCH = "DenyOnNomatch";
    public static final String UNKNOWN_POLICY = "UnknownPolicy";
    protected int matchReturnValue = 1;
    protected int noMatchReturnValue = -1;

    public void setMatchReturnValue(String filterReturnValue) {
        if (filterReturnValue.equalsIgnoreCase("accept")) {
            this.matchReturnValue = 1;
        } else if (filterReturnValue.equalsIgnoreCase("deny")) {
            this.matchReturnValue = -1;
        } else if (filterReturnValue.equalsIgnoreCase("neutral")) {
            this.matchReturnValue = 0;
        } else {
            LogLog.error("invalid matchReturnValue: " + filterReturnValue);
        }
    }

    public String getMatchReturnValue() {
        if (this.matchReturnValue == 1) {
            return "accept";
        }
        if (this.matchReturnValue == -1) {
            return "deny";
        }
        if (this.matchReturnValue == 0) {
            return "neutral";
        }
        return "unknown";
    }

    public void setNoMatchReturnValue(String filterReturnValue) {
        if (filterReturnValue.equalsIgnoreCase("accept")) {
            this.noMatchReturnValue = 1;
        } else if (filterReturnValue.equalsIgnoreCase("deny")) {
            this.noMatchReturnValue = -1;
        } else if (filterReturnValue.equalsIgnoreCase("neutral")) {
            this.noMatchReturnValue = 0;
        } else {
            LogLog.error("invalid noMatchReturnValue: " + filterReturnValue);
        }
    }

    public String getNoMatchReturnValue() {
        if (this.noMatchReturnValue == 1) {
            return "accept";
        }
        if (this.noMatchReturnValue == -1) {
            return "deny";
        }
        if (this.noMatchReturnValue == 0) {
            return "neutral";
        }
        return "unknown";
    }

    public void setChainPolicy(String policyStr) {
        if (policyStr.equalsIgnoreCase(ACCEPT_ON_MATCH)) {
            this.matchReturnValue = 1;
            this.noMatchReturnValue = 0;
        } else if (policyStr.equalsIgnoreCase(DENY_ON_MATCH)) {
            this.matchReturnValue = -1;
            this.noMatchReturnValue = 0;
        } else if (policyStr.equalsIgnoreCase(ACCEPT_ON_NOMATCH)) {
            this.matchReturnValue = 0;
            this.noMatchReturnValue = 1;
        } else if (policyStr.equalsIgnoreCase(DENY_ON_NOMATCH)) {
            this.matchReturnValue = 0;
            this.noMatchReturnValue = -1;
        } else {
            LogLog.error("invalid chainPolicy: " + policyStr);
        }
    }

    public String getChainPolicy() {
        if (this.matchReturnValue == 1 && this.noMatchReturnValue == 0) {
            return ACCEPT_ON_MATCH;
        }
        if (this.matchReturnValue == -1 && this.noMatchReturnValue == 0) {
            return DENY_ON_MATCH;
        }
        if (this.matchReturnValue == 0 && this.noMatchReturnValue == 1) {
            return ACCEPT_ON_NOMATCH;
        }
        if (this.matchReturnValue == 0 && this.noMatchReturnValue == -1) {
            return DENY_ON_NOMATCH;
        }
        return UNKNOWN_POLICY;
    }

    public int decide(LoggingEvent event) {
        if (this.canMatch()) {
            if (this.match(event)) {
                return this.matchReturnValue;
            }
            return this.noMatchReturnValue;
        }
        return 0;
    }

    protected boolean canMatch() {
        return true;
    }

    protected abstract boolean match(LoggingEvent var1);
}

