/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="tail", description="Displays the last lines of a file.")
public class TailAction
extends AbstractAction {
    private static final int DEFAULT_NUMBER_OF_LINES = 10;
    private static final int DEFAULT_SLEEP_INTERVAL = 200;
    @Option(name="-n", aliases={}, description="The number of lines to display, starting at 1.", required=false, multiValued=false)
    private int numberOfLines;
    @Option(name="-f", aliases={}, description="Follow file changes", required=false, multiValued=false)
    private boolean continuous;
    @Option(name="-s", aliases={}, description="Sleep interval (used for follow)", required=false, multiValued=false)
    private long sleepInterval;
    @Argument(index=0, name="path or url", description="A file path or url to display.", required=false, multiValued=false)
    private String path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (this.path == null || this.path.trim().length() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Tailing STDIN");
            }
            this.tail(new BufferedReader(new InputStreamReader(System.in)));
        } else {
            BufferedReader reader;
            try {
                URL url = new URL(this.path);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Tailing URL: " + url);
                }
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (MalformedURLException ignore) {
                File file = new File(this.path);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Tailing file: " + file);
                }
                reader = new BufferedReader(new FileReader(file));
            }
            try {
                this.tail(reader);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void tail(BufferedReader reader) throws InterruptedException, IOException {
        String line;
        if (this.numberOfLines < 1) {
            this.numberOfLines = 10;
        }
        if (this.sleepInterval < 1L) {
            this.sleepInterval = 200L;
        }
        LinkedList<String> lines = new LinkedList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
            if (lines.size() <= this.numberOfLines) continue;
            lines.removeFirst();
        }
        for (String l : lines) {
            System.out.println(l);
        }
        while (this.continuous) {
            Thread.sleep(this.sleepInterval);
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

