/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.felix.fileinstall.internal.BundleTransformer;
import org.apache.felix.fileinstall.internal.ConfigInstaller;
import org.apache.felix.fileinstall.internal.DirectoryWatcher;
import org.apache.felix.fileinstall.internal.JarDirUrlHandler;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class FileInstall
implements BundleActivator {
    static ServiceTracker padmin;
    static ServiceTracker startLevel;
    static Runnable cmSupport;
    static final Map listeners;
    static final BundleTransformer bundleTransformer;
    BundleContext context;
    Map watchers = new HashMap();
    ServiceTracker listenersTracker;
    static boolean initialized;
    static final Object barrier;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.context = context;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("url.handler.protocol", "jardir");
        context.registerService(URLStreamHandlerService.class.getName(), (Object)new JarDirUrlHandler(), props);
        padmin = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        padmin.open();
        startLevel = new ServiceTracker(context, StartLevel.class.getName(), null);
        startLevel.open();
        String flt = "(|(objectClass=" + ArtifactInstaller.class.getName() + ")" + "(" + "objectClass" + "=" + ArtifactTransformer.class.getName() + ")" + "(" + "objectClass" + "=" + ArtifactUrlTransformer.class.getName() + "))";
        this.listenersTracker = new ServiceTracker(context, FrameworkUtil.createFilter((String)flt), null){

            public Object addingService(ServiceReference serviceReference) {
                ArtifactListener listener = (ArtifactListener)super.addingService(serviceReference);
                FileInstall.this.addListener(serviceReference, listener);
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                super.modifiedService(reference, service);
                FileInstall.this.removeListener(reference);
                FileInstall.this.addListener(reference, (ArtifactListener)service);
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                FileInstall.this.removeListener(serviceReference);
            }
        };
        this.listenersTracker.open();
        try {
            cmSupport = new ConfigAdminSupport(context, this);
        }
        catch (NoClassDefFoundError e) {
            Util.log(context, Util.getGlobalLogLevel(context), 4, "ConfigAdmin is not available, some features will be disabled", e);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        this.set(ht, "felix.fileinstall.poll");
        this.set(ht, "felix.fileinstall.dir");
        this.set(ht, "felix.fileinstall.log.level");
        this.set(ht, "felix.fileinstall.filter");
        this.set(ht, "felix.fileinstall.tmpdir");
        this.set(ht, "felix.fileinstall.bundles.new.start");
        this.set(ht, "felix.fileinstall.bundles.startTransient");
        this.set(ht, "felix.fileinstall.noInitialDelay");
        this.set(ht, "felix.fileinstall.start.level");
        String dirs = (String)ht.get("felix.fileinstall.dir");
        if (dirs != null && dirs.indexOf(44) != -1) {
            StringTokenizer st = new StringTokenizer(dirs, ",");
            int index = 0;
            while (st.hasMoreTokens()) {
                String dir = st.nextToken().trim();
                ht.put("felix.fileinstall.dir", dir);
                String name = "initial";
                if (index > 0) {
                    name = name + index;
                }
                this.updated(name, new Hashtable(ht));
                ++index;
            }
        } else {
            this.updated("initial", ht);
        }
        Object object = barrier;
        synchronized (object) {
            initialized = true;
            barrier.notifyAll();
        }
    }

    private void set(Hashtable ht, String key) {
        String o = this.context.getProperty(key);
        if (o == null && (o = System.getProperty(key.toUpperCase().replace('.', '_'))) == null) {
            return;
        }
        ht.put(key, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = barrier;
        synchronized (object) {
            initialized = false;
        }
        ArrayList toClose = new ArrayList();
        Map map = this.watchers;
        synchronized (map) {
            toClose.addAll(this.watchers.values());
            this.watchers.clear();
        }
        Iterator w = toClose.iterator();
        while (w.hasNext()) {
            try {
                DirectoryWatcher dir = (DirectoryWatcher)w.next();
                dir.close();
            }
            catch (Exception e) {}
        }
        if (this.listenersTracker != null) {
            this.listenersTracker.close();
        }
        if (cmSupport != null) {
            cmSupport.run();
        }
        if (padmin != null) {
            padmin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        DirectoryWatcher watcher;
        Map map = this.watchers;
        synchronized (map) {
            watcher = (DirectoryWatcher)this.watchers.remove(pid);
        }
        if (watcher != null) {
            watcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) {
        InterpolationHelper.performSubstitution(new DictionaryAsMap<String, String>(properties), this.context);
        DirectoryWatcher watcher = null;
        Map map = this.watchers;
        synchronized (map) {
            watcher = (DirectoryWatcher)this.watchers.get(pid);
            if (watcher != null && watcher.getProperties().equals(properties)) {
                return;
            }
        }
        if (watcher != null) {
            watcher.close();
        }
        watcher = new DirectoryWatcher(properties, this.context);
        map = this.watchers;
        synchronized (map) {
            this.watchers.put(pid, watcher);
        }
        watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(ServiceReference reference, ArtifactListener listener) {
        Map map = listeners;
        synchronized (map) {
            listeners.put(reference, listener);
        }
        this.notifyWatchers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(ServiceReference reference) {
        Map map = listeners;
        synchronized (map) {
            listeners.remove(reference);
        }
        this.notifyWatchers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWatchers() {
        ArrayList toNotify = new ArrayList();
        Map map = this.watchers;
        synchronized (map) {
            toNotify.addAll(this.watchers.values());
        }
        Iterator w = toNotify.iterator();
        while (w.hasNext()) {
            DirectoryWatcher dir;
            DirectoryWatcher directoryWatcher = dir = (DirectoryWatcher)w.next();
            synchronized (directoryWatcher) {
                dir.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getListeners() {
        Map map = listeners;
        synchronized (map) {
            ArrayList l = new ArrayList(listeners.values());
            Collections.reverse(l);
            l.add(bundleTransformer);
            return l;
        }
    }

    static PackageAdmin getPackageAdmin() {
        return FileInstall.getPackageAdmin(10000L);
    }

    static PackageAdmin getPackageAdmin(long timeout) {
        try {
            return (PackageAdmin)padmin.waitForService(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static StartLevel getStartLevel() {
        return FileInstall.getStartLevel(10000L);
    }

    static StartLevel getStartLevel(long timeout) {
        try {
            return (StartLevel)startLevel.waitForService(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    static {
        listeners = new TreeMap();
        bundleTransformer = new BundleTransformer();
        barrier = new Object();
    }

    private static class ConfigAdminSupport
    implements Runnable {
        private Tracker tracker;

        private ConfigAdminSupport(BundleContext context, FileInstall fileInstall) {
            this.tracker = new Tracker(context, fileInstall);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("service.pid", this.tracker.getName());
            context.registerService((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = FileInstall.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), (Object)this.tracker, props);
            this.tracker.open();
        }

        public void run() {
            this.tracker.close();
        }

        private class Tracker
        extends ServiceTracker
        implements ManagedServiceFactory {
            private final FileInstall fileInstall;
            private ConfigInstaller configInstaller;

            private Tracker(BundleContext bundleContext, FileInstall fileInstall) {
                super(bundleContext, (class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = FileInstall.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName(), null);
                this.fileInstall = fileInstall;
            }

            public String getName() {
                return "org.apache.felix.fileinstall";
            }

            public void updated(String s, Dictionary dictionary) throws ConfigurationException {
                this.fileInstall.updated(s, dictionary);
            }

            public void deleted(String s) {
                this.fileInstall.deleted(s);
            }

            public Object addingService(ServiceReference serviceReference) {
                ConfigurationAdmin cm = (ConfigurationAdmin)super.addingService(serviceReference);
                this.configInstaller = new ConfigInstaller(this.context, cm);
                this.configInstaller.init();
                return cm;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                if (this.configInstaller != null) {
                    this.configInstaller.destroy();
                    this.configInstaller = null;
                }
                super.removedService(serviceReference, o);
            }
        }
    }
}

