/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.log.Level;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="log", name="set", description="Sets the log level.")
public class SetLogLevel
extends OsgiCommandSupport {
    @Argument(index=0, name="level", description="The log level to set (TRACE, DEBUG, INFO, WARN, ERROR) or DEFAULT to unset", required=true, multiValued=false)
    String level;
    @Argument(index=1, name="logger", description="Logger name or ROOT (default)", required=false, multiValued=false)
    String logger;
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ROOT_LOGGER = "ROOT";

    protected Object doExecute() throws Exception {
        if (ROOT_LOGGER.equalsIgnoreCase(this.logger)) {
            this.logger = null;
        }
        this.level = this.level.toUpperCase();
        try {
            Level.valueOf(this.level);
        }
        catch (IllegalArgumentException e) {
            System.err.println("level must be set to TRACE, DEBUG, INFO, WARN or ERROR (or DEFAULT to unset it)");
            return null;
        }
        if (Level.isDefault(this.level) && this.logger == null) {
            System.err.println("Can not unset the ROOT logger");
            return null;
        }
        Configuration cfg = this.getConfiguration();
        Dictionary props = cfg.getProperties();
        String logger = this.logger;
        String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
        String val = (String)props.get(prop);
        if (Level.isDefault(this.level)) {
            if (val != null) {
                int idx = (val = val.trim()).indexOf(",");
                val = idx < 0 ? null : val.substring(idx);
            }
        } else {
            int idx;
            val = val == null ? this.level : ((idx = (val = val.trim()).indexOf(",")) < 0 ? this.level : this.level + val.substring(idx));
        }
        if (val == null) {
            props.remove(prop);
        } else {
            props.put(prop, val);
        }
        cfg.update(props);
        return null;
    }

    protected Configuration getConfiguration() throws IOException {
        Configuration cfg = this.getConfigAdmin().getConfiguration(CONFIGURATION_PID, null);
        return cfg;
    }

    protected ConfigurationAdmin getConfigAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        return (ConfigurationAdmin)this.getService(ConfigurationAdmin.class, ref);
    }
}

