/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.ServicePermission;

final class ServicePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private transient Map permissions = new HashMap();
    private boolean all_allowed = false;
    private Map filterPermissions;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("all_allowed", Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.HashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("filterPermissions", clazz2);
        serialPersistentFields = objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ServicePermission sp = (ServicePermission)permission;
        if (sp.service != null) {
            throw new IllegalArgumentException("cannot add to collection: " + sp);
        }
        String name = sp.getName();
        Filter f = sp.filter;
        ServicePermissionCollection servicePermissionCollection = this;
        synchronized (servicePermissionCollection) {
            ServicePermission existing;
            HashMap<String, ServicePermission> pc;
            if (f != null) {
                pc = this.filterPermissions;
                if (pc == null) {
                    this.filterPermissions = pc = new HashMap<String, ServicePermission>();
                }
            } else {
                pc = this.permissions;
            }
            if ((existing = (ServicePermission)pc.get(name)) != null) {
                int oldMask = existing.action_mask;
                int newMask = sp.action_mask;
                if (oldMask != newMask) {
                    pc.put(name, new ServicePermission(name, oldMask | newMask));
                }
            } else {
                pc.put(name, sp);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean implies(Permission permission) {
        Collection perms;
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission requested = (ServicePermission)permission;
        if (requested.filter != null) {
            return false;
        }
        int effective = 0;
        ServicePermissionCollection servicePermissionCollection = this;
        synchronized (servicePermissionCollection) {
            Map pc;
            ServicePermission sp;
            int desired = requested.action_mask;
            if (this.all_allowed && (sp = (ServicePermission)this.permissions.get("*")) != null && ((effective |= sp.action_mask) & desired) == desired) {
                return true;
            }
            String[] requestedNames = requested.objectClass;
            if (requestedNames == null) {
                if (((effective |= this.effective(requested.getName(), desired, effective)) & desired) == desired) {
                    return true;
                }
            } else {
                int i = 0;
                int l = requestedNames.length;
                while (i < l) {
                    if ((this.effective(requestedNames[i], desired, effective) & desired) == desired) {
                        return true;
                    }
                    ++i;
                }
            }
            if ((pc = this.filterPermissions) == null) {
                return false;
            }
            perms = pc.values();
        }
        Iterator iter = perms.iterator();
        while (iter.hasNext()) {
            if (!((ServicePermission)iter.next()).implies0(requested, effective)) continue;
            return true;
        }
        return false;
    }

    private int effective(String requestedName, int desired, int effective) {
        int last;
        Map pc = this.permissions;
        ServicePermission sp = (ServicePermission)pc.get(requestedName);
        if (sp != null && ((effective |= sp.action_mask) & desired) == desired) {
            return effective;
        }
        int offset = requestedName.length() - 1;
        while ((last = requestedName.lastIndexOf(".", offset)) != -1) {
            sp = (ServicePermission)pc.get(requestedName = String.valueOf(requestedName.substring(0, last + 1)) + "*");
            if (sp != null && ((effective |= sp.action_mask) & desired) == desired) {
                return effective;
            }
            offset = last - 1;
        }
        return effective;
    }

    public synchronized Enumeration elements() {
        ArrayList all = new ArrayList(this.permissions.values());
        Map pc = this.filterPermissions;
        if (pc != null) {
            all.addAll(pc.values());
        }
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable hashtable = new Hashtable(this.permissions);
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", hashtable);
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("filterPermissions", this.filterPermissions);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable hashtable = (Hashtable)gfields.get("permissions", null);
        this.permissions = new HashMap(hashtable);
        this.all_allowed = gfields.get("all_allowed", false);
        this.filterPermissions = (HashMap)gfields.get("filterPermissions", null);
    }
}

