/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.BlueprintExtender;
import org.apache.aries.blueprint.container.BlueprintRepository;
import org.apache.aries.blueprint.container.DestroyCallback;
import org.apache.aries.blueprint.container.ServiceRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.quiesce.manager.QuiesceCallback;
import org.apache.aries.quiesce.participant.QuiesceParticipant;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintQuiesceParticipant
implements QuiesceParticipant {
    private final BundleContext ctx;
    private final BlueprintExtender extender;
    private final ExecutorService executor = new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Blueprint-Container-ThreadPool");
            t.setDaemon(true);
            return t;
        }
    });

    public BlueprintQuiesceParticipant(BundleContext context, BlueprintExtender extender) {
        this.ctx = context;
        this.extender = extender;
    }

    public void quiesce(QuiesceCallback callback, List<Bundle> bundlesToQuiesce) {
        boolean shutdownMe = false;
        for (Bundle b : bundlesToQuiesce) {
            try {
                this.executor.execute(new QuiesceBundle(callback, b, this.extender));
            }
            catch (RejectedExecutionException re) {
                // empty catch block
            }
            shutdownMe |= b.equals(this.ctx.getBundle());
        }
        if (shutdownMe) {
            this.executor.shutdown();
        }
    }

    private static final class QuiesceDelegatingCallback
    implements DestroyCallback {
        private final QuiesceCallback callback;
        private final Bundle toQuiesce;
        private final Set<String> services = new HashSet<String>();

        public QuiesceDelegatingCallback(QuiesceCallback cbk, Bundle b) {
            ServiceReference[] serviceRefs;
            this.callback = cbk;
            this.toQuiesce = b;
            for (ServiceReference ref : serviceRefs = b.getRegisteredServices()) {
                this.services.add(b.getBundleContext().getService(ref).toString());
            }
        }

        public void callback(Object key) {
            if (key != null && this.services.remove(key.toString()) && this.services.isEmpty()) {
                this.callback.bundleQuiesced(new Bundle[]{this.toQuiesce});
            }
        }
    }

    private static final class QuiesceBundle
    implements Runnable {
        private final Bundle bundleToQuiesce;
        private final QuiesceCallback callback;
        private final BlueprintExtender extender;

        public QuiesceBundle(QuiesceCallback callback, Bundle bundleToQuiesce, BlueprintExtender extender) {
            this.callback = callback;
            this.bundleToQuiesce = bundleToQuiesce;
            this.extender = extender;
        }

        public void run() {
            BlueprintContainerImpl container = this.extender.getBlueprintContainerImpl(this.bundleToQuiesce);
            if (container != null) {
                BlueprintRepository repository = container.getRepository();
                Set<String> names = repository.getNames();
                container.quiesce();
                boolean hasServices = false;
                for (String name : names) {
                    Recipe recipe = repository.getRecipe(name);
                    if (!(recipe instanceof ServiceRecipe)) continue;
                    hasServices = true;
                    ((ServiceRecipe)recipe).quiesce(new QuiesceDelegatingCallback(this.callback, this.bundleToQuiesce));
                }
                if (!hasServices) {
                    this.callback.bundleQuiesced(new Bundle[]{this.bundleToQuiesce});
                }
            } else {
                this.callback.bundleQuiesced(new Bundle[]{this.bundleToQuiesce});
            }
        }
    }
}

