/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class GenericSpecificationImpl
extends VersionConstraintImpl
implements GenericSpecification {
    private Filter matchingFilter;
    private String type = "generic";
    private int resolution = 0;
    private GenericDescription[] suppliers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMatchingFilter() {
        Object object = this.monitor;
        synchronized (object) {
            return this.matchingFilter == null ? null : this.matchingFilter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMatchingFilter(String matchingFilter) throws InvalidSyntaxException {
        Object object = this.monitor;
        synchronized (object) {
            this.matchingFilter = matchingFilter == null ? null : FilterImpl.newInstance(matchingFilter);
        }
    }

    public boolean isSatisfiedBy(BaseDescription supplier) {
        if (!(supplier instanceof GenericDescription)) {
            return false;
        }
        GenericDescription candidate = (GenericDescription)supplier;
        if (this.getName() == null || !this.getName().equals(candidate.getName())) {
            return false;
        }
        if (this.getType() == null || !this.getType().equals(candidate.getType())) {
            return false;
        }
        return this.matchingFilter == null || this.matchingFilter.match(candidate.getAttributes());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Eclipse-GenericRequire").append(": ").append(this.getName());
        if (this.getType() != "generic") {
            sb.append(':').append(this.getType());
        }
        if (this.matchingFilter != null) {
            sb.append("; ").append(this.getMatchingFilter());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() {
        Object object = this.monitor;
        synchronized (object) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setType(String type) {
        Object object = this.monitor;
        synchronized (object) {
            this.type = type == null || type.equals("generic") ? "generic" : type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResolution() {
        Object object = this.monitor;
        synchronized (object) {
            return this.resolution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers != null && this.suppliers.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResolution(int resolution) {
        Object object = this.monitor;
        synchronized (object) {
            this.resolution = resolution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDescription getSupplier() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers == null || this.suppliers.length == 0 ? null : this.suppliers[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSupplier(BaseDescription supplier) {
        Object object = this.monitor;
        synchronized (object) {
            if (supplier == null) {
                this.suppliers = null;
                return;
            }
            int len = this.suppliers == null ? 0 : this.suppliers.length;
            GenericDescription[] temp = new GenericDescription[len + 1];
            if (this.suppliers != null) {
                System.arraycopy(this.suppliers, 0, temp, 0, len);
            }
            temp[len] = (GenericDescription)supplier;
            this.suppliers = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescription[] getSuppliers() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSupplers(GenericDescription[] suppliers) {
        Object object = this.monitor;
        synchronized (object) {
            this.suppliers = suppliers;
        }
    }
}

