/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.common;

import java.io.OutputStreamWriter;
import org.apache.karaf.diagnostic.core.common.TextDumpProvider;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;

public class FeaturesDumpProvider
extends TextDumpProvider {
    private final FeaturesService features;

    public FeaturesDumpProvider(FeaturesService features) {
        super("features.txt");
        this.features = features;
    }

    protected void writeDump(OutputStreamWriter outputStreamWriter) throws Exception {
        outputStreamWriter.write("Repositories:\n");
        for (Repository repository : this.features.listRepositories()) {
            outputStreamWriter.write(repository.getURI() + " (" + repository.getName() + ")\n");
        }
        outputStreamWriter.write("\nfeatures:\n");
        for (Repository repository : this.features.listFeatures()) {
            outputStreamWriter.write(repository.getName() + " " + repository.getVersion());
            outputStreamWriter.write(" installed: " + this.features.isInstalled((Feature)repository));
            outputStreamWriter.write("\nBundles:\n");
            for (BundleInfo bundle : repository.getBundles()) {
                outputStreamWriter.write("\t" + bundle.getLocation());
                if (bundle.getStartLevel() != 0) {
                    outputStreamWriter.write(" start level " + bundle.getStartLevel());
                }
                outputStreamWriter.write("\n\n");
            }
        }
        outputStreamWriter.close();
    }
}

