/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.SubstituteLoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.impl.StaticLoggerBinder;

public final class LoggerFactory {
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String MULTIPLE_BINDINGS_URL = "http://www.slf4j.org/codes.html#multiple_bindings";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    static final String UNSUCCESSFUL_INIT_URL = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String UNSUCCESSFUL_INIT_MSG = "org.slf4j.LoggerFactory could not be successfully initialized. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final int UNINITIALIZED = 0;
    static final int ONGOING_INITILIZATION = 1;
    static final int FAILED_INITILIZATION = 2;
    static final int SUCCESSFUL_INITILIZATION = 3;
    static final int GET_SINGLETON_INEXISTENT = 1;
    static final int GET_SINGLETON_EXISTS = 2;
    static int INITIALIZATION_STATE = 0;
    static int GET_SINGLETON_METHOD = 0;
    static SubstituteLoggerFactory TEMP_FACTORY = new SubstituteLoggerFactory();
    private static final String[] API_COMPATIBILITY_LIST = new String[]{"1.5.5", "1.5.6", "1.5.7", "1.5.8", "1.5.9", "1.5.10", "1.5.11"};
    private static String STATIC_LOGGER_BINDER_PATH = "org/slf4j/impl/StaticLoggerBinder.class";

    private LoggerFactory() {
    }

    static void reset() {
        INITIALIZATION_STATE = 0;
        GET_SINGLETON_METHOD = 0;
        TEMP_FACTORY = new SubstituteLoggerFactory();
    }

    private static final void performInitialization() {
        LoggerFactory.bind();
        LoggerFactory.versionSanityCheck();
        LoggerFactory.singleImplementationSanityCheck();
    }

    private static boolean messageContainsOrgSlf4jImplStaticLoggerBinder(String msg) {
        if (msg == null) {
            return false;
        }
        if (msg.indexOf("org/slf4j/impl/StaticLoggerBinder") != -1) {
            return true;
        }
        return msg.indexOf("org.slf4j.impl.StaticLoggerBinder") != -1;
    }

    private static final void bind() {
        try {
            LoggerFactory.getSingleton();
            INITIALIZATION_STATE = 3;
            LoggerFactory.emitSubstituteLoggerWarning();
        }
        catch (NoClassDefFoundError ncde) {
            INITIALIZATION_STATE = 2;
            String msg = ncde.getMessage();
            if (LoggerFactory.messageContainsOrgSlf4jImplStaticLoggerBinder(msg)) {
                Util.report("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.report("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            throw ncde;
        }
        catch (Exception e) {
            INITIALIZATION_STATE = 2;
            Util.report("Failed to instantiate logger [" + LoggerFactory.getSingleton().getLoggerFactoryClassStr() + "]", e);
        }
    }

    private static final void emitSubstituteLoggerWarning() {
        List loggerNameList = TEMP_FACTORY.getLoggerNameList();
        if (loggerNameList.size() == 0) {
            return;
        }
        Util.report("The following loggers will not work because they were created");
        Util.report("during the default configuration phase of the underlying logging system.");
        Util.report("See also http://www.slf4j.org/codes.html#substituteLogger");
        for (int i = 0; i < loggerNameList.size(); ++i) {
            String loggerName = (String)loggerNameList.get(i);
            Util.report(loggerName);
        }
    }

    private static final void versionSanityCheck() {
        try {
            String requested = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean match = false;
            for (int i = 0; i < API_COMPATIBILITY_LIST.length; ++i) {
                if (!requested.startsWith(API_COMPATIBILITY_LIST[i])) continue;
                match = true;
            }
            if (!match) {
                Util.report("The requested version " + requested + " by your slf4j binding is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString());
                Util.report("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError nsfe) {
        }
        catch (Throwable e) {
            Util.report("Unexpected problem occured during version sanity check", e);
        }
    }

    private static void singleImplementationSanityCheck() {
        try {
            ClassLoader loggerFactoryClassLoader = LoggerFactory.class.getClassLoader();
            if (loggerFactoryClassLoader == null) {
                return;
            }
            Enumeration<URL> paths = loggerFactoryClassLoader.getResources(STATIC_LOGGER_BINDER_PATH);
            LinkedHashSet<URL> implementationSet = new LinkedHashSet<URL>();
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                implementationSet.add(path);
            }
            if (implementationSet.size() > 1) {
                Util.report("Class path contains multiple SLF4J bindings.");
                Iterator iterator = implementationSet.iterator();
                while (iterator.hasNext()) {
                    URL path = (URL)iterator.next();
                    Util.report("Found binding in [" + path + "]");
                }
                Util.report("See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
            }
        }
        catch (IOException ioe) {
            Util.report("Error getting resources from path", ioe);
        }
    }

    private static final StaticLoggerBinder getSingleton() {
        if (GET_SINGLETON_METHOD == 1) {
            return StaticLoggerBinder.SINGLETON;
        }
        if (GET_SINGLETON_METHOD == 2) {
            return StaticLoggerBinder.getSingleton();
        }
        try {
            StaticLoggerBinder singleton = StaticLoggerBinder.getSingleton();
            GET_SINGLETON_METHOD = 2;
            return singleton;
        }
        catch (NoSuchMethodError nsme) {
            GET_SINGLETON_METHOD = 1;
            return StaticLoggerBinder.SINGLETON;
        }
    }

    public static Logger getLogger(String name) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        if (INITIALIZATION_STATE == 0) {
            INITIALIZATION_STATE = 1;
            LoggerFactory.performInitialization();
        }
        switch (INITIALIZATION_STATE) {
            case 3: {
                return LoggerFactory.getSingleton().getLoggerFactory();
            }
            case 2: {
                throw new IllegalStateException(UNSUCCESSFUL_INIT_MSG);
            }
            case 1: {
                return TEMP_FACTORY;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }
}

