/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import jline.Terminal;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.RuntimeSshException;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.impl.SimpleLogger;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String appName = "Apache Karaf";
        try {
            Properties props = new Properties();
            props.load(new FileReader(System.getProperty("karaf.base") + System.getProperty("file.separator") + "etc" + System.getProperty("file.separator") + "custom.properties"));
            Object prop = props.get("karaf.app.name");
            if (prop != null) {
                appName = (String)prop;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String host = "localhost";
        int port = 8101;
        String user = "karaf";
        String password = "karaf";
        StringBuilder sb = new StringBuilder();
        int level = 1;
        int retryAttempts = 0;
        int retryDelay = 2;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    host = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    user = args[++i];
                    continue;
                }
                if (args[i].equals("-p")) {
                    password = args[++i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++level;
                    continue;
                }
                if (args[i].equals("-r")) {
                    retryAttempts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    retryDelay = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("--help")) {
                    System.out.println(appName + " client");
                    System.out.println("  -a [port]     specify the port to connect to");
                    System.out.println("  -h [host]     specify the host to connect to");
                    System.out.println("  -u [user]     specify the user name");
                    System.out.println("  -p [password] specify the password");
                    System.out.println("  --help        shows this help message");
                    System.out.println("  -v            raise verbosity");
                    System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
                    System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
                    System.out.println("  [commands]    commands to run");
                    System.out.println("If no commands are specified, the client will be put in an interactive mode");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            sb.append(args[i]);
            sb.append(' ');
        }
        SimpleLogger.setLevel(level);
        SshClient client = null;
        Terminal terminal = null;
        try {
            ClientChannel channel;
            client = SshClient.setUpDefaultClient();
            client.start();
            int retries = 0;
            ClientSession session = null;
            do {
                ConnectFuture future = client.connect(host, port);
                future.await();
                try {
                    session = future.getSession();
                }
                catch (RuntimeSshException ex) {
                    if (retries++ < retryAttempts) {
                        Thread.sleep(retryDelay * 1000);
                        System.out.println("retrying (attempt " + retries + ") ...");
                        continue;
                    }
                    throw ex;
                }
            } while (session == null);
            if (!((AuthFuture)session.authPassword(user, password).await()).isSuccess()) {
                throw new Exception("Authentication failure");
            }
            if (sb.length() > 0) {
                channel = session.createChannel("exec", sb.append("\n").toString());
                channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
            } else {
                terminal = new TerminalFactory().getTerminal();
                channel = session.createChannel("shell");
                ConsoleInputStream in = new ConsoleInputStream(terminal.wrapInIfNeeded(System.in));
                new Thread(in).start();
                channel.setIn((InputStream)in);
                ((ChannelShell)channel).setupSensibleDefaultPty();
            }
            channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)System.out));
            channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)System.err));
            channel.open();
            channel.waitFor(2, 0L);
        }
        catch (Throwable t) {
            if (level > 1) {
                t.printStackTrace();
            } else {
                System.err.println(t.getMessage());
            }
            System.exit(1);
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {}
            try {
                if (terminal != null) {
                    terminal.restore();
                }
            }
            catch (Throwable t) {}
        }
        System.exit(0);
    }

    private static class ConsoleInputStream
    extends InputStream
    implements Runnable {
        private InputStream in;
        private boolean eof = false;
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public ConsoleInputStream(InputStream in) {
            this.in = in;
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (this.eof && this.queue.isEmpty()) {
                return -1;
            }
            if (wait) {
                try {
                    i = this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                i = (Integer)this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        public int read() throws IOException {
            return this.read(true);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }

        public int available() throws IOException {
            return this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    c = this.in.read();
                    if (c == -1) {
                        this.eof = true;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable t) {
                    this.eof = true;
                    try {
                        this.queue.put(-1);
                        return;
                    }
                    catch (InterruptedException var2_4) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable var3_5) {
                    this.eof = true;
                    try {
                        this.queue.put(-1);
                        throw var3_5;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    throw var3_5;
                }
                try {
                    this.queue.put(-1);
                    return;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    this.queue.put(c);
                    continue;
                }
                break;
            }
        }
    }
}

