/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.osgi.BundlesCommandOptional;
import org.apache.karaf.shell.osgi.Util;
import org.apache.karaf.util.StringEscapeUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="osgi", name="info", description="Displays detailed information of a given bundle.")
public class Info
extends BundlesCommandOptional {
    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        if (bundles == null) {
            Bundle[] allBundles = this.getBundleContext().getBundles();
            for (int i = 0; i < allBundles.length; ++i) {
                this.printInfo(allBundles[i]);
            }
        } else {
            for (Bundle bundle : bundles) {
                this.printInfo(bundle);
            }
        }
    }

    protected void printInfo(Bundle bundle) {
        String title = Util.getBundleName(bundle);
        System.out.println("\n" + title);
        System.out.println(Util.getUnderlineString(title));
        URL bundleInfo = bundle.getEntry("OSGI-INF/bundle.info");
        if (bundleInfo != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(bundleInfo.openStream()));
                while ((line = reader.readLine()) != null) {
                    System.out.println(StringEscapeUtils.unescapeJava(line));
                }
                reader.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

