/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.osgi.BundlesCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="osgi", name="bundle-services", description="List OSGi services per bundle")
public class ListBundleServices
extends BundlesCommand {
    @Option(name="-a", aliases={}, description="Shows all services. (By default Karaf commands are hidden)", required=false, multiValued=false)
    boolean showAll;
    @Option(name="-u", aliases={}, description="Shows the services each bundle uses. (By default the provided services are shown)", required=false, multiValued=false)
    boolean inUse;
    @Option(name="-p", aliases={}, description="Shows the properties of the services", required=false, multiValued=false)
    boolean showProperties = false;

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        for (Bundle bundle : bundles) {
            ServiceReference[] refs = this.inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
            this.printServices(bundle, refs, this.showProperties);
        }
    }

    private void printServices(Bundle bundle, ServiceReference<?>[] refs, boolean showProperties) {
        boolean headerPrinted = false;
        boolean needSeparator = false;
        if (refs == null) {
            return;
        }
        for (ServiceReference<?> serviceRef : refs) {
            boolean print;
            String[] objectClass = (String[])serviceRef.getProperty("objectClass");
            boolean bl = print = this.showAll || !this.isCommand(objectClass);
            if (!headerPrinted) {
                headerPrinted = true;
                System.out.println("");
                String title = bundle.getSymbolicName() + (this.inUse ? " uses:" : " provides:");
                System.out.println(title);
                System.out.println("----------------------------------");
            }
            if (!print) continue;
            if (needSeparator && showProperties) {
                System.out.println("----");
            }
            if (showProperties) {
                this.printProperties(serviceRef);
            } else {
                System.out.println(ListBundleServices.getValueString(objectClass));
            }
            needSeparator = true;
        }
    }

    private boolean isCommand(String[] objectClasses) {
        for (String objectClass : objectClasses) {
            if (!objectClass.equals(Function.class.getName())) continue;
            return true;
        }
        return false;
    }

    private void printProperties(ServiceReference<?> serviceRef) {
        for (String key : serviceRef.getPropertyKeys()) {
            System.out.println(key + " = " + ListBundleServices.getValueString(serviceRef.getProperty(key)));
        }
    }

    private static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    private static String getUnderlineString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append('-');
        }
        return sb.toString();
    }

    private static String getValueString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ListBundleServices.getValueString(array[i]));
            }
            sb.append("]");
            return sb.toString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Boolean) {
            return ((Boolean)obj).toString();
        }
        if (obj instanceof Long) {
            return ((Long)obj).toString();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).toString();
        }
        if (obj instanceof Short) {
            return ((Short)obj).toString();
        }
        if (obj instanceof Double) {
            return ((Double)obj).toString();
        }
        if (obj instanceof Float) {
            return ((Float)obj).toString();
        }
        if (obj instanceof URL) {
            return ((URL)obj).toExternalForm();
        }
        if (obj instanceof URI) {
            try {
                return ((URI)obj).toURL().toExternalForm();
            }
            catch (MalformedURLException e) {
                return obj.toString();
            }
        }
        return obj.toString();
    }
}

