/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="cat", description="Displays the content of a file or URL.")
public class CatAction
extends AbstractAction {
    @Option(name="-n", aliases={}, description="Number the output lines, starting at 1.", required=false, multiValued=false)
    private boolean displayLineNumbers;
    @Argument(index=0, name="paths or urls", description="A list of file paths or urls to display separated by whitespace (use - for STDIN)", required=true, multiValued=true)
    private List<String> paths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (this.paths.size() == 1 && "-".equals(this.paths.get(0))) {
            this.log.info("Printing STDIN");
            this.cat(new BufferedReader(new InputStreamReader(System.in)));
        } else {
            for (String filename : this.paths) {
                BufferedReader reader;
                try {
                    URL url = new URL(filename);
                    this.log.info("Printing URL: " + url);
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                }
                catch (MalformedURLException ignore) {
                    File file = new File(filename);
                    this.log.info("Printing file: " + file);
                    reader = new BufferedReader(new FileReader(file));
                }
                try {
                    this.cat(reader);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return null;
    }

    private void cat(BufferedReader reader) throws IOException {
        String line;
        int lineno = 1;
        while ((line = reader.readLine()) != null) {
            if (this.displayLineNumbers) {
                System.out.print(String.format("%6d  ", lineno++));
            }
            System.out.println(line);
        }
    }
}

