/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.di;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayRecipe
extends AbstractRecipe {
    private final List<Recipe> list;
    private final Object type;

    public ArrayRecipe(String name, Object type) {
        super(name);
        this.type = type;
        this.list = new ArrayList<Recipe>();
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.list.size());
        for (Recipe recipe : this.list) {
            if (recipe == null) continue;
            nestedRecipes.add(recipe);
        }
        return nestedRecipes;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        Object array;
        ReifiedType type = this.type instanceof Class ? new ReifiedType((Class)this.type) : (this.type instanceof String ? this.loadType((String)this.type) : new ReifiedType(Object.class));
        try {
            array = Array.newInstance(type.getRawClass(), this.list.size());
        }
        catch (Exception e) {
            throw new ComponentDefinitionException("Error while creating array instance: " + type);
        }
        int index = 0;
        for (Recipe recipe : this.list) {
            Object value;
            if (recipe != null) {
                try {
                    value = this.convert(recipe.create(), type);
                }
                catch (Exception e) {
                    throw new ComponentDefinitionException("Unable to convert value " + recipe + " to type " + type, (Throwable)e);
                }
            } else {
                value = null;
            }
            Array.set(array, index, value);
            ++index;
        }
        return array;
    }

    public void add(Recipe value) {
        this.list.add(value);
    }
}

