/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiException
extends Exception {
    private List<Exception> exceptions = new ArrayList<Exception>();

    public MultiException(String message) {
        super(message);
    }

    public MultiException(String message, List<Exception> exceptions) {
        super(message);
        this.exceptions = exceptions;
    }

    public void addException(Exception e) {
        this.exceptions.add(e);
    }

    public void throwIfExceptions() throws MultiException {
        if (!this.exceptions.isEmpty()) {
            throw this;
        }
    }

    public Throwable[] getCauses() {
        return this.exceptions.toArray(new Throwable[this.exceptions.size()]);
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        for (Exception e : this.exceptions) {
            e.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        for (Exception e : this.exceptions) {
            e.printStackTrace(out);
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        for (Exception e : this.exceptions) {
            e.printStackTrace(out);
        }
    }

    public static void throwIf(String message, List<Exception> exceptions) throws MultiException {
        if (exceptions != null && !exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder(message);
            sb.append(":");
            for (Exception e : exceptions) {
                sb.append("\n\t");
                sb.append(e.getMessage());
            }
            throw new MultiException(sb.toString(), exceptions);
        }
    }
}

