/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="users", description="List the users of the selected JAAS Realm/Login Module")
public class ListUsersCommand
extends JaasCommandSupport {
    private static final String OUTPUT_FORMAT = "%-20s %-20s";

    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (realm == null || entry == null) {
            System.err.println("No JAAS Realm / Module has been selected.");
            return null;
        }
        BackingEngine engine = this.backingEngineService.get(entry);
        if (engine == null) {
            System.err.println("Can't get the list of users:");
            System.err.println("No backing engine serivce found for:" + entry.getOptions().get("org.apache.karaf.jaas.module"));
            return null;
        }
        return this.doExecute(engine);
    }

    protected Object doExecute(BackingEngine engine) throws Exception {
        List users = engine.listUsers();
        System.out.println(String.format(OUTPUT_FORMAT, "User Name", "Role"));
        for (UserPrincipal user : users) {
            String userName = user.getName();
            List roles = engine.listRoles(user);
            if (roles != null && roles.size() >= 1) {
                for (RolePrincipal role : roles) {
                    String roleName = role.getName();
                    System.out.println(String.format(OUTPUT_FORMAT, userName, roleName));
                }
                continue;
            }
            System.out.println(String.format(OUTPUT_FORMAT, userName, ""));
        }
        return null;
    }
}

