/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.FakeURLStreamHandler;
import org.apache.felix.framework.Felix;
import org.osgi.framework.wiring.BundleRevision;

public class BundleProtectionDomain
extends ProtectionDomain {
    private final WeakReference m_felix;
    private final WeakReference m_bundle;
    private final int m_hashCode;
    private final String m_toString;
    private final WeakReference m_revision;

    BundleProtectionDomain(Felix felix, BundleImpl bundle, Object certificates) throws MalformedURLException {
        super(new CodeSource(Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "location:", new FakeURLStreamHandler()), bundle._getLocation(), new FakeURLStreamHandler()), (Certificate[])certificates), null);
        this.m_felix = new WeakReference<Felix>(felix);
        this.m_bundle = new WeakReference<BundleImpl>(bundle);
        this.m_revision = new WeakReference<BundleRevisionImpl>(bundle.adapt(BundleRevisionImpl.class));
        this.m_hashCode = bundle.hashCode();
        this.m_toString = "[" + bundle + "]";
    }

    BundleRevision getRevision() {
        return (BundleRevision)this.m_revision.get();
    }

    public boolean implies(Permission permission) {
        Felix felix = (Felix)this.m_felix.get();
        return felix != null ? felix.impliesBundlePermission(this, permission, false) : false;
    }

    public boolean impliesDirect(Permission permission) {
        Felix felix = (Felix)this.m_felix.get();
        return felix != null ? felix.impliesBundlePermission(this, permission, true) : false;
    }

    BundleImpl getBundle() {
        return (BundleImpl)this.m_bundle.get();
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != BundleProtectionDomain.class) {
            return false;
        }
        if (this.m_hashCode != other.hashCode()) {
            return false;
        }
        return this.m_bundle.get() == ((BundleProtectionDomain)other).m_bundle.get();
    }

    public String toString() {
        return this.m_toString;
    }
}

