/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.util.Collection;
import org.apache.felix.framework.monitor.MonitoringService;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

@Command(scope="dev", name="classloaders", description="Show leaking bundle classloaders.")
public class ClassLoaders
extends OsgiCommandSupport {
    private MonitoringService monitoringService;

    protected Object doExecute() throws Exception {
        Bundle bundle;
        Collection cls = this.monitoringService.getClassLoaders();
        boolean leaking = false;
        for (ClassLoader cl : cls) {
            bundle = ((BundleReference)cl).getBundle();
            leaking |= bundle.getState() < 4;
        }
        if (leaking) {
            System.out.println("Leaking classloaders for bundles:");
            for (ClassLoader cl : cls) {
                bundle = ((BundleReference)cl).getBundle();
                if (bundle.getState() >= 4) continue;
                System.out.println("  " + bundle.getSymbolicName() + " " + bundle.getVersion());
            }
        } else {
            System.out.println("No classloader leaks detected for bundles");
        }
        return null;
    }

    public MonitoringService getMonitoringService() {
        return this.monitoringService;
    }

    public void setMonitoringService(MonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }
}

