/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.sshd.client.SshdSocketAddress;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.OpenChannelException;

public class ChannelForwardedTcpip
extends AbstractServerChannel {
    private IoConnector connector;
    private IoSession ioSession;
    private OutputStream out;

    protected OpenFuture doInit(Buffer buffer) {
        SshdSocketAddress address;
        final DefaultOpenFuture f = new DefaultOpenFuture(this);
        String hostToConnect = buffer.getString();
        int portToConnect = buffer.getInt();
        String originatorIpAddress = buffer.getString();
        int originatorPort = buffer.getInt();
        this.log.info("Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", new Object[]{hostToConnect, portToConnect, originatorIpAddress, originatorPort});
        ClientSessionImpl clientSession = (ClientSessionImpl)this.getSession();
        try {
            address = clientSession.getForwardedPort(portToConnect);
        }
        catch (RuntimeException e) {
            address = null;
        }
        if (address == null) {
            super.close(true);
            f.setException(new OpenChannelException(1, "connect denied"));
            return f;
        }
        this.connector = new NioSocketConnector();
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        IoHandlerAdapter handler = new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                IoBuffer ioBuffer = (IoBuffer)message;
                int r = ioBuffer.remaining();
                byte[] b = new byte[r];
                ioBuffer.get(b, 0, r);
                ChannelForwardedTcpip.this.out.write(b, 0, r);
                ChannelForwardedTcpip.this.out.flush();
            }

            public void sessionClosed(IoSession session) throws Exception {
                if (!ChannelForwardedTcpip.this.closing) {
                    ChannelForwardedTcpip.this.sendEof();
                }
            }
        };
        this.connector.setHandler((IoHandler)handler);
        ConnectFuture future = this.connector.connect((SocketAddress)address.toInetSocketAddress());
        future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                if (future.isConnected()) {
                    ChannelForwardedTcpip.this.ioSession = future.getSession();
                    f.setOpened();
                } else if (future.getException() != null) {
                    ChannelForwardedTcpip.this.closeImmediately0();
                    if (future.getException() instanceof ConnectException) {
                        f.setException(new OpenChannelException(2, future.getException().getMessage(), future.getException()));
                    } else {
                        f.setException(future.getException());
                    }
                }
            }
        });
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
        new Thread("ChannelDirectTcpip-ConnectorCleanup"){

            public void run() {
                ChannelForwardedTcpip.this.connector.dispose();
            }
        }.start();
    }

    public CloseFuture close(boolean immediately) {
        return (CloseFuture)super.close(immediately).addListener(new SshFutureListener(){

            public void operationComplete(SshFuture sshFuture) {
                ChannelForwardedTcpip.this.closeImmediately0();
            }
        });
    }

    public void handleEof() throws IOException {
        super.handleEof();
        this.close(false);
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        IoBuffer buf = IoBuffer.allocate((int)len);
        buf.put(data, off, len);
        buf.flip();
        this.ioSession.write((Object)buf);
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("DirectTcpip channel does not support extended data");
    }

    public void handleRequest(Buffer buffer) throws IOException {
        this.log.info("Received SSH_MSG_CHANNEL_REQUEST on channel {}", (Object)this.id);
        String type = buffer.getString();
        this.log.info("Received channel request: {}", (Object)type);
        buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
        buffer.putInt(this.recipient);
        this.session.writePacket(buffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "forwarded-tcpip";
        }

        @Override
        public Channel create() {
            return new ChannelForwardedTcpip();
        }
    }
}

