/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.Buffer;

public class ChannelPipedInputStream
extends InputStream {
    private final Window localWindow;
    private final Buffer buffer = new Buffer();
    private final byte[] b = new byte[1];
    private boolean closed;
    private boolean writerClosed;

    public ChannelPipedInputStream(Window localWindow) {
        this.localWindow = localWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            int avail = this.buffer.available();
            if (avail == 0 && this.writerClosed) {
                return -1;
            }
            return avail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        byte[] byArray = this.b;
        synchronized (this.b) {
            int l = this.read(this.b, 0, 1);
            if (l == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.b[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int avail;
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            while (true) {
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                if (this.buffer.available() > 0) break;
                if (this.writerClosed) {
                    return -1;
                }
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
            if (len > this.buffer.available()) {
                len = this.buffer.available();
            }
            this.buffer.getRawBytes(b, off, len);
            if (this.buffer.rpos() > this.localWindow.getPacketSize() || this.buffer.available() == 0) {
                this.buffer.compact();
            }
            avail = this.localWindow.getMaxSize() - this.buffer.available();
        }
        this.localWindow.check(avail);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eof() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.writerClosed = true;
            this.buffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.closed = true;
            this.buffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(byte[] bytes, int off, int len) throws IOException {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.writerClosed || this.closed) {
                throw new IOException("Pipe closed");
            }
            this.buffer.putRawBytes(bytes, off, len);
            this.buffer.notifyAll();
        }
        this.localWindow.consume(len);
    }
}

