/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.common.AgentDelegate;
import org.apache.sshd.agent.local.AgentServerProxy;
import org.apache.sshd.agent.local.ChannelAgentForwarding;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.session.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KarafAgentFactory
implements SshAgentFactory {
    private final Map<String, AgentServerProxy> proxies = new ConcurrentHashMap<String, AgentServerProxy>();
    private final Map<String, SshAgent> locals = new ConcurrentHashMap<String, SshAgent>();

    public NamedFactory<Channel> getChannelForwardingFactory() {
        return new ChannelAgentForwarding.Factory();
    }

    public SshAgent createClient(Session session) throws IOException {
        String proxyId = (String)session.getFactoryManager().getProperties().get("SSH_AUTH_SOCK");
        if (proxyId == null) {
            throw new IllegalStateException("No SSH_AUTH_SOCK environment variable set");
        }
        AgentServerProxy proxy = this.proxies.get(proxyId);
        if (proxy != null) {
            return proxy.createClient();
        }
        SshAgent agent = this.locals.get(proxyId);
        if (agent != null) {
            return new AgentDelegate(agent);
        }
        throw new IllegalStateException("No ssh agent found");
    }

    public SshAgentServer createServer(Session session) throws IOException {
        if (!(session instanceof ServerSession)) {
            throw new IllegalStateException("The session used to create an agent server proxy must be a server session");
        }
        final AgentServerProxy proxy = new AgentServerProxy((ServerSession)session);
        this.proxies.put(proxy.getId(), proxy);
        return new SshAgentServer(){

            public String getId() {
                return proxy.getId();
            }

            public void close() {
                KarafAgentFactory.this.proxies.remove(proxy.getId());
                proxy.close();
            }
        };
    }

    public void registerAgent(SshAgent agent, Map<String, ?> properties) {
        if (agent != null) {
            Object id = properties.get("id");
            if (id == null) {
                throw new IllegalStateException("Local agent can't be registered with no 'id' property");
            }
            this.locals.put(id.toString(), agent);
        }
    }

    public void unregisterAgent(SshAgent agent, Map<String, ?> properties) {
        if (agent != null) {
            Object id = properties.get("id");
            if (id == null) {
                throw new IllegalStateException("Local agent can't be unregistered with no 'id' property");
            }
            this.locals.remove(id.toString());
        }
    }
}

