/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="realms", description="List JAAS Realms")
public class ListRealmsCommand
extends JaasCommandSupport {
    private static final String REALM_LIST_FORMAT = "%5s %-20s %-80s";

    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }

    protected Object doExecute() throws Exception {
        List<JaasRealm> realms = this.getRealms();
        if (realms != null && realms.size() > 0) {
            System.out.println(String.format(REALM_LIST_FORMAT, "Index", "Realm", "Module Class"));
            Map<AppConfigurationEntry, JaasRealm> appConfigurationEntries = this.findEntries();
            if (!appConfigurationEntries.isEmpty()) {
                int index = 1;
                for (AppConfigurationEntry entry : appConfigurationEntries.keySet()) {
                    String moduleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
                    System.out.println(String.format(REALM_LIST_FORMAT, index++, appConfigurationEntries.get(entry).getName(), moduleClass));
                }
            }
        } else {
            System.err.println("No realm found");
        }
        return null;
    }
}

