/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanRegistrer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanRegistrer.class);
    private final ConcurrentMap<MBeanServer, Set<String>> mbeanServers = new ConcurrentHashMap<MBeanServer, Set<String>>();
    private Map<Object, String> mbeans;
    private BundleContext context;
    private ServiceTracker tracker;

    public void setMbeans(Map<Object, String> mbeans) {
        this.mbeans = mbeans;
    }

    public void setBundleContext(BundleContext context) {
        this.context = context;
    }

    public void init() throws Exception {
        this.tracker = new ServiceTracker(this.context, MBeanServer.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Object service = MBeanRegistrer.this.context.getService(reference);
                MBeanRegistrer.this.registerMBeans((MBeanServer)service);
                return service;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                MBeanRegistrer.this.unregisterMBeans((MBeanServer)service);
                MBeanRegistrer.this.context.ungetService(reference);
            }
        });
        this.tracker.open();
    }

    public void destroy() throws Exception {
        this.tracker.close();
    }

    protected void registerMBeans(MBeanServer mbeanServer) {
        HashSet<String> registered;
        if (mbeanServer != null && this.mbeans != null && this.mbeanServers.putIfAbsent(mbeanServer, registered = new HashSet<String>()) == null) {
            for (Map.Entry<Object, String> entry : this.mbeans.entrySet()) {
                String name = this.parseProperty(entry.getValue());
                try {
                    ObjectName oname = new ObjectName(name);
                    try {
                        mbeanServer.registerMBean(entry.getKey(), oname);
                    }
                    catch (InstanceAlreadyExistsException e) {
                        mbeanServer.unregisterMBean(oname);
                        mbeanServer.registerMBean(entry.getKey(), oname);
                    }
                    registered.add(name);
                }
                catch (JMException e) {
                    LOGGER.warn("Unable to register mbean {}", (Object)name, (Object)e);
                }
            }
        }
    }

    protected void unregisterMBeans(MBeanServer mbeanServer) {
        Set registered;
        if (mbeanServer != null && this.mbeans != null && (registered = (Set)this.mbeanServers.remove(mbeanServer)) != null) {
            while (!registered.isEmpty()) {
                String name = (String)registered.iterator().next();
                try {
                    mbeanServer.unregisterMBean(new ObjectName(name));
                }
                catch (JMException e) {
                    LOGGER.warn("Unable to unregister mbean {}", (Object)name, (Object)e);
                }
                registered.remove(name);
            }
        }
    }

    protected String parseProperty(String raw) {
        String var;
        String val;
        if (raw.indexOf("${") > -1 && raw.indexOf("}", raw.indexOf("${")) > -1 && (val = System.getProperty(var = raw.substring(raw.indexOf("${") + 2, raw.indexOf("}")))) != null) {
            raw = raw.replace("${" + var + "}", val);
        }
        return raw;
    }
}

