/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.simple;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jline.Terminal;
import jline.console.KeyMap;
import org.fusesource.jansi.Ansi;
import org.jledit.AbstractConsoleEditor;
import org.jledit.EditorOperation;
import org.jledit.EditorOperationType;
import org.jledit.command.Command;
import org.jledit.command.CommandNotFoundException;
import org.jledit.command.editor.BackspaceCommand;
import org.jledit.command.editor.DeleteCommand;
import org.jledit.command.editor.FindCommand;
import org.jledit.command.editor.FindNextCommand;
import org.jledit.command.editor.FindPreviousCommand;
import org.jledit.command.editor.GoToCommand;
import org.jledit.command.editor.MoveCursorDownCommand;
import org.jledit.command.editor.MoveCursorLeftCommand;
import org.jledit.command.editor.MoveCursorRightCommand;
import org.jledit.command.editor.MoveCursorToEndOfLineCommand;
import org.jledit.command.editor.MoveCursorToStartOfLineCommand;
import org.jledit.command.editor.MoveCursorUpCommand;
import org.jledit.command.editor.NewLineCommand;
import org.jledit.command.editor.PasteCommand;
import org.jledit.command.editor.QuitCommand;
import org.jledit.command.editor.TypeCommand;
import org.jledit.command.file.FileCloseCommand;
import org.jledit.command.file.FileOpenCommand;
import org.jledit.command.file.FileSaveCommand;
import org.jledit.command.undo.RedoCommand;
import org.jledit.command.undo.UndoCommand;
import org.jledit.utils.JlEditConsole;
import org.jledit.utils.Strings;
import org.jledit.utils.internal.KeyMaps;

public class SimpleConsoleEditor
extends AbstractConsoleEditor {
    private final Map<String, String> supportedOperations = new LinkedHashMap<String, String>();
    private final List<String> helpLines = new LinkedList<String>();

    public SimpleConsoleEditor(Terminal terminal) throws Exception {
        super(terminal);
        this.setKeys(this.createKeyMap());
        this.supportedOperations.put("^O", "Open");
        this.supportedOperations.put("^X", "Quit");
        this.supportedOperations.put("^S", "Save");
        this.supportedOperations.put("^Z", "Undo");
        this.supportedOperations.put("^R", "Redo");
        this.supportedOperations.put("^G", "Go To");
        this.supportedOperations.put("^F", "Find");
        this.supportedOperations.put("^N", "Next");
        this.supportedOperations.put("^P", "Previous");
        this.addHelpLines(this.helpLines);
        this.setFooterSize(this.helpLines.size() + 1);
    }

    @Override
    public void redrawHeader() {
        this.saveCursorPosition();
        JlEditConsole.out.print(Ansi.ansi().cursor(1, 1));
        Ansi style = Ansi.ansi();
        if (this.getTheme().getHeaderBackground() != null) {
            style.bg(this.getTheme().getHeaderBackground());
        }
        if (this.getTheme().getHeaderForeground() != null) {
            style.fg(this.getTheme().getHeaderForeground());
        }
        String textCoords = "L:" + this.getLine() + " C:" + this.getColumn();
        int displayFileLength = this.getTerminal().getWidth() - this.getTitle().length() - textCoords.length() - 1;
        JlEditConsole.out.print(style.a(this.getTitle()).a(":").a(Strings.tryToTrimToSize(this.getDisplayAs(), displayFileLength)).a(this.isDirty() != false ? "*" : "").eraseLine(Ansi.Erase.FORWARD));
        JlEditConsole.out.print(Ansi.ansi().cursor(1, this.getTerminal().getWidth() - textCoords.length()));
        JlEditConsole.out.print(Ansi.ansi().a(textCoords).reset());
        JlEditConsole.out.print(Ansi.ansi().cursor(this.getTerminal().getHeight(), 1));
        this.restoreCursorPosition();
    }

    @Override
    public void redrawFooter() {
        this.saveCursorPosition();
        Ansi style = Ansi.ansi();
        if (this.getTheme().getFooterBackground() != null) {
            style.bg(this.getTheme().getFooterBackground());
        }
        if (this.getTheme().getFooterForeground() != null) {
            style.fg(this.getTheme().getFooterForeground());
        }
        JlEditConsole.out.print(style);
        JlEditConsole.out.print(Ansi.ansi().cursor(this.getTerminal().getHeight() + 1 - this.getFooterSize(), 1).eraseLine(Ansi.Erase.FORWARD));
        for (int i = 1; i <= this.helpLines.size(); ++i) {
            String helpLine = this.helpLines.get(i - 1);
            int startColumn = (this.getTerminal().getWidth() - helpLine.length()) / 2;
            JlEditConsole.out.print(Ansi.ansi().cursor(this.getTerminal().getHeight() + 1 - this.getFooterSize() + i, 1).eraseLine(Ansi.Erase.FORWARD));
            JlEditConsole.out.print(Ansi.ansi().cursor(this.getTerminal().getHeight() + 1 - this.getFooterSize() + i, startColumn));
            JlEditConsole.out.print(helpLine);
        }
        JlEditConsole.out.print(Ansi.ansi().reset());
        this.restoreCursorPosition();
    }

    @Override
    public void redrawCoords() {
        this.redrawHeader();
    }

    private void addHelpLines(List<String> helpLines) {
        helpLines.clear();
        StringBuilder sb = new StringBuilder();
        boolean startOfLine = true;
        for (Map.Entry<String, String> entry : this.supportedOperations.entrySet()) {
            String txt;
            String key = entry.getKey();
            String desc = entry.getValue();
            if (startOfLine) {
                txt = key + " " + desc;
                startOfLine = false;
            } else {
                txt = "    " + key + " " + desc;
            }
            if (txt.length() + sb.length() > this.getTerminal().getWidth()) {
                helpLines.add(sb.toString());
                sb.delete(0, sb.length());
                startOfLine = true;
            }
            sb.append(txt);
        }
        helpLines.add(sb.toString());
    }

    @Override
    public Command create(EditorOperation operation) throws CommandNotFoundException {
        switch (operation.getType()) {
            case TYPE: {
                return new TypeCommand(this, operation.getInput());
            }
            case NEWLINE: {
                return new NewLineCommand(this);
            }
            case BACKSAPCE: {
                return new BackspaceCommand(this);
            }
            case DELETE: {
                return new DeleteCommand(this);
            }
            case PASTE: {
                return new PasteCommand(this);
            }
            case HOME: {
                return new MoveCursorToStartOfLineCommand(this);
            }
            case END: {
                return new MoveCursorToEndOfLineCommand(this);
            }
            case UP: {
                return new MoveCursorUpCommand(this);
            }
            case DOWN: {
                return new MoveCursorDownCommand(this);
            }
            case LEFT: {
                return new MoveCursorLeftCommand(this);
            }
            case RIGHT: {
                return new MoveCursorRightCommand(this);
            }
            case SAVE: {
                return new FileSaveCommand(this);
            }
            case OPEN: {
                return new FileOpenCommand(this, null);
            }
            case CLOSE: {
                return new FileCloseCommand(this);
            }
            case QUIT: {
                return new QuitCommand(this);
            }
            case UNDO: {
                return new UndoCommand(this, this.getUndoContext());
            }
            case REDO: {
                return new RedoCommand(this.getUndoContext());
            }
            case FIND: {
                return new FindCommand(this);
            }
            case FIND_NEXT: {
                return new FindNextCommand(this, null);
            }
            case FIND_PREVIOUS: {
                return new FindPreviousCommand(this, null);
            }
            case GOTO: {
                return new GoToCommand(this);
            }
        }
        throw new CommandNotFoundException("Could not find command for Operation");
    }

    private KeyMap createKeyMap() {
        char c;
        Object[] ctrl = new Object[]{null, null, null, null, null, null, EditorOperationType.FIND, EditorOperationType.GOTO, EditorOperationType.BACKSAPCE, null, EditorOperationType.NEWLINE, null, null, EditorOperationType.NEWLINE, EditorOperationType.FIND_NEXT, EditorOperationType.OPEN, EditorOperationType.FIND_PREVIOUS, EditorOperationType.QUIT, EditorOperationType.REDO, EditorOperationType.SAVE, null, EditorOperationType.UNDO, EditorOperationType.PASTE, null, EditorOperationType.QUIT, null, EditorOperationType.UNDO, null, null, null, null, null};
        KeyMap simpleKeyMap = new KeyMap("simple", false);
        for (c = '\u0000'; c < ctrl.length; c = (char)(c + '\u0001')) {
            simpleKeyMap.bind(Character.toString(c), ctrl[c]);
        }
        for (c = ' '; c < '\u0100'; c = (char)(c + '\u0001')) {
            simpleKeyMap.bind(Character.toString(c), (Object)EditorOperationType.TYPE);
        }
        simpleKeyMap.bind(Character.toString('\u007f'), (Object)EditorOperationType.BACKSAPCE);
        KeyMaps.bindArrowKeys(simpleKeyMap);
        return simpleKeyMap;
    }

    @Override
    public void setDirty(Boolean dirty) {
        super.setDirty(dirty);
        this.redrawHeader();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (readOnly) {
            this.supportedOperations.remove("^S");
        } else {
            this.supportedOperations.put("^S", "Save");
        }
        this.addHelpLines(this.helpLines);
    }

    @Override
    public void setOpenEnabled(boolean openEnabled) {
        super.setOpenEnabled(openEnabled);
        if (!openEnabled) {
            this.supportedOperations.remove("^O");
        } else {
            this.supportedOperations.put("^O", "Open");
        }
        this.addHelpLines(this.helpLines);
    }
}

