/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx;

import java.util.concurrent.ExecutorService;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractCompendiumHandler
extends ServiceTracker
implements MBeanHandler {
    protected final JMXAgentContext agentContext;
    protected StandardMBean mbean;
    protected Long trackedId;

    protected AbstractCompendiumHandler(JMXAgentContext agentContext, Filter filter) {
        super(agentContext.getBundleContext(), filter, null);
        this.agentContext = agentContext;
    }

    protected AbstractCompendiumHandler(JMXAgentContext agentContext, String clazz) {
        super(agentContext.getBundleContext(), clazz, null);
        this.agentContext = agentContext;
    }

    public Object addingService(ServiceReference reference) {
        Logger logger = this.agentContext.getLogger();
        Object trackedService = null;
        Long serviceId = (Long)reference.getProperty("service.id");
        if (this.trackedId != null) {
            String serviceDescription = this.getServiceDescription(reference);
            logger.log(2, "Detected secondary ServiceReference for [" + serviceDescription + "] with " + "service.id" + " [" + serviceId + "] Only 1 instance will be JMX managed");
        } else {
            logger.log(3, "Registering MBean with ObjectName [" + this.getName() + "] for service with " + "service.id" + " [" + serviceId + "]");
            trackedService = this.context.getService(reference);
            this.mbean = this.constructInjectMBean(trackedService);
            ExecutorService executor = this.agentContext.getRegistrationExecutor();
            executor.submit(new Runnable(){

                public void run() {
                    AbstractCompendiumHandler.this.agentContext.registerMBean(AbstractCompendiumHandler.this);
                }
            });
            this.trackedId = serviceId;
        }
        return trackedService;
    }

    public void removedService(ServiceReference reference, Object service) {
        Logger logger = this.agentContext.getLogger();
        Long serviceID = (Long)reference.getProperty("service.id");
        if (this.trackedId != null && !this.trackedId.equals(serviceID)) {
            String serviceDescription = this.getServiceDescription(reference);
            logger.log(2, "ServiceReference for [" + serviceDescription + "] with " + "service.id" + " [" + serviceID + "] is not currently JMX managed");
        } else {
            logger.log(3, "Unregistering MBean with ObjectName [" + this.getName() + "] for service with " + "service.id" + " [" + serviceID + "]");
            ExecutorService executor = this.agentContext.getRegistrationExecutor();
            executor.submit(new Runnable(){

                public void run() {
                    AbstractCompendiumHandler.this.agentContext.unregisterMBean(AbstractCompendiumHandler.this);
                }
            });
            this.trackedId = null;
            this.context.ungetService(reference);
        }
    }

    private String getServiceDescription(ServiceReference reference) {
        String serviceDescription = (String)reference.getProperty("service.description");
        if (serviceDescription == null) {
            Object obj = reference.getProperty("objectClass");
            if (obj instanceof String) {
                StringBuilder sb = new StringBuilder();
                for (String s : (String[])obj) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(s);
                }
                serviceDescription = sb.toString();
            } else {
                serviceDescription = obj.toString();
            }
        }
        return serviceDescription;
    }

    public StandardMBean getMbean() {
        return this.mbean;
    }

    protected abstract StandardMBean constructInjectMBean(Object var1);
}

