/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.aries.blueprint.annotation.service.BlueprintAnnotationScanner;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.BlueprintEventDispatcher;
import org.apache.aries.blueprint.container.BlueprintQuiesceParticipant;
import org.apache.aries.blueprint.container.BlueprintThreadFactory;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.container.ParserServiceImpl;
import org.apache.aries.blueprint.namespace.NamespaceHandlerRegistryImpl;
import org.apache.aries.blueprint.services.ParserService;
import org.apache.aries.blueprint.utils.HeaderParser;
import org.apache.aries.blueprint.utils.threading.ScheduledExecutorServiceWrapper;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.util.AriesFrameworkUtil;
import org.apache.aries.util.tracker.RecursiveBundleTracker;
import org.apache.aries.util.tracker.SingleServiceTracker;
import org.apache.felix.framework.monitor.MonitoringService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintExtender
implements BundleActivator,
BundleTrackerCustomizer,
SynchronousBundleListener {
    private static final String QUIESCE_PARTICIPANT_CLASS = "org.apache.aries.quiesce.participant.QuiesceParticipant";
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintExtender.class);
    private BundleContext context;
    private ScheduledExecutorService executors;
    private final ConcurrentMap<Bundle, BlueprintContainerImpl> containers = new ConcurrentHashMap<Bundle, BlueprintContainerImpl>();
    private final ConcurrentMap<Bundle, FutureTask> destroying = new ConcurrentHashMap<Bundle, FutureTask>();
    private BlueprintEventDispatcher eventDispatcher;
    private NamespaceHandlerRegistry handlers;
    private RecursiveBundleTracker bt;
    private ServiceRegistration parserServiceReg;
    private ServiceRegistration quiesceParticipantReg;
    private SingleServiceTracker<ProxyManager> proxyManager;
    private ExecutorServiceFinder executorServiceFinder;
    private volatile boolean stopping;

    public void start(BundleContext ctx) {
        LOGGER.debug("Starting blueprint extender...");
        this.context = ctx;
        try {
            this.executorServiceFinder = new FelixExecutorServiceFinder();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.handlers = new NamespaceHandlerRegistryImpl(ctx);
        this.executors = new ScheduledExecutorServiceWrapper(ctx, "Blueprint Extender", new ScheduledExecutorServiceWrapper.ScheduledExecutorServiceFactory(){

            public ScheduledExecutorService create(String name) {
                return Executors.newScheduledThreadPool(3, new BlueprintThreadFactory(name));
            }
        });
        this.eventDispatcher = new BlueprintEventDispatcher(ctx, this.executors);
        this.context.addBundleListener((BundleListener)this);
        int mask = 62;
        this.bt = new RecursiveBundleTracker(ctx, mask, (BundleTrackerCustomizer)this);
        this.proxyManager = new SingleServiceTracker(ctx, ProxyManager.class, new SingleServiceTracker.SingleServiceListener(){

            public void serviceFound() {
                LOGGER.debug("Found ProxyManager service, starting to process blueprint bundles");
                BlueprintExtender.this.bt.open();
            }

            public void serviceLost() {
                while (!BlueprintExtender.this.containers.isEmpty()) {
                    for (Bundle bundle : BlueprintExtender.this.getBundlesToDestroy()) {
                        BlueprintExtender.this.destroyContainer(bundle);
                    }
                }
                BlueprintExtender.this.bt.close();
            }

            public void serviceReplaced() {
            }
        });
        this.proxyManager.open();
        this.parserServiceReg = ctx.registerService(ParserService.class.getName(), (Object)new ParserServiceImpl(this.handlers), new Hashtable());
        try {
            ctx.getBundle().loadClass(QUIESCE_PARTICIPANT_CLASS);
            this.quiesceParticipantReg = ctx.registerService(QUIESCE_PARTICIPANT_CLASS, (Object)new BlueprintQuiesceParticipant(ctx, this), new Hashtable());
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("No quiesce support is available, so blueprint components will not participate in quiesce operations");
        }
        LOGGER.debug("Blueprint extender started");
    }

    public void stop(BundleContext context) {
        LOGGER.debug("Stopping blueprint extender...");
        this.stopping = true;
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.parserServiceReg);
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.quiesceParticipantReg);
        while (!this.containers.isEmpty()) {
            for (Bundle bundle : this.getBundlesToDestroy()) {
                this.destroyContainer(bundle);
            }
        }
        this.bt.close();
        this.proxyManager.close();
        this.eventDispatcher.destroy();
        this.handlers.destroy();
        this.executors.shutdown();
        LOGGER.debug("Blueprint extender stopped");
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (bundle.getState() != 32 && bundle.getState() != 8 && bundle != this.context.getBundle()) {
            this.destroyContainer(bundle);
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        String activationPolicyHeader;
        String val;
        if (this.context.getBundle(0L).equals(bundle) && bundle.getState() == 16 && ((val = this.context.getProperty("org.apache.aries.blueprint.preemptiveShutdown")) == null || Boolean.parseBoolean(val))) {
            this.stop(this.context);
            return;
        }
        if (bundle.getState() != 32 && bundle.getState() != 8) {
            if (bundle != this.context.getBundle()) {
                this.destroyContainer(bundle);
            }
            return;
        }
        if (this.stopping) {
            return;
        }
        if (!(bundle.getState() != 8 || (activationPolicyHeader = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy"))) {
            return;
        }
        this.createContainer(bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.destroyContainer(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createContainer(Bundle bundle) {
        try {
            List<Object> paths = this.getBlueprintPaths(bundle);
            if (paths == null) {
                return false;
            }
            ProxyManager pm = (ProxyManager)this.proxyManager.getService();
            if (pm == null) {
                return false;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                return false;
            }
            BlueprintContainerImpl blueprintContainer = new BlueprintContainerImpl(bundle, bundleContext, this.context.getBundle(), this.eventDispatcher, this.handlers, this.getExecutorService(bundle), this.executors, paths, pm);
            ConcurrentMap<Bundle, BlueprintContainerImpl> concurrentMap = this.containers;
            synchronized (concurrentMap) {
                if (this.containers.putIfAbsent(bundle, blueprintContainer) != null) {
                    return false;
                }
            }
            String val = this.context.getProperty("org.apache.aries.blueprint.synchronous");
            if (Boolean.parseBoolean(val)) {
                LOGGER.debug("Starting creation of blueprint bundle {} synchronously", (Object)bundle.getSymbolicName());
                blueprintContainer.run();
            } else {
                LOGGER.debug("Scheduling creation of blueprint bundle {} asynchronously", (Object)bundle.getSymbolicName());
                blueprintContainer.schedule();
            }
            return true;
        }
        catch (Throwable t) {
            LOGGER.warn("Error while creating blueprint container for bundle " + bundle, t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyContainer(final Bundle bundle) {
        FutureTask<Object> future;
        ConcurrentMap<Bundle, BlueprintContainerImpl> concurrentMap = this.containers;
        synchronized (concurrentMap) {
            LOGGER.debug("Starting BlueprintContainer destruction process for bundle {}", (Object)bundle.getSymbolicName());
            future = (FutureTask<Object>)this.destroying.get(bundle);
            if (future == null) {
                final BlueprintContainerImpl blueprintContainer = (BlueprintContainerImpl)this.containers.remove(bundle);
                if (blueprintContainer != null) {
                    LOGGER.debug("Scheduling BlueprintContainer destruction for {}.", (Object)bundle.getSymbolicName());
                    future = new FutureTask<Object>(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            LOGGER.info("Destroying BlueprintContainer for bundle {}", (Object)bundle.getSymbolicName());
                            try {
                                blueprintContainer.destroy();
                            }
                            finally {
                                LOGGER.debug("Finished destroying BlueprintContainer for bundle {}", (Object)bundle.getSymbolicName());
                                BlueprintExtender.this.eventDispatcher.removeBlueprintBundle(bundle);
                                ConcurrentMap concurrentMap = BlueprintExtender.this.containers;
                                synchronized (concurrentMap) {
                                    BlueprintExtender.this.destroying.remove(bundle);
                                }
                            }
                        }
                    }, null);
                    this.destroying.put(bundle, future);
                } else {
                    LOGGER.debug("Not a blueprint bundle or destruction of BlueprintContainer already finished for {}.", (Object)bundle.getSymbolicName());
                }
            } else {
                LOGGER.debug("Destruction already scheduled for {}.", (Object)bundle.getSymbolicName());
            }
        }
        if (future != null) {
            try {
                LOGGER.debug("Waiting for BlueprintContainer destruction for {}.", (Object)bundle.getSymbolicName());
                future.run();
                future.get();
            }
            catch (Throwable t) {
                LOGGER.warn("Error while destroying blueprint container for bundle " + bundle, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getBlueprintPaths(Bundle bundle) {
        block18: {
            LOGGER.debug("Scanning bundle {} for blueprint application", (Object)bundle.getSymbolicName());
            try {
                ArrayList<Object> pathList = new ArrayList<Object>();
                String blueprintHeader = (String)bundle.getHeaders().get("Bundle-Blueprint");
                String blueprintHeaderAnnotation = (String)bundle.getHeaders().get("Bundle-Blueprint-Annotation");
                if (blueprintHeader == null) {
                    blueprintHeader = "OSGI-INF/blueprint/";
                }
                List<HeaderParser.PathElement> paths = HeaderParser.parseHeader(blueprintHeader);
                for (HeaderParser.PathElement path : paths) {
                    String filePattern;
                    String baseName;
                    String name = path.getName();
                    if (name.endsWith("/")) {
                        this.addEntries(bundle, name, "*.xml", pathList);
                        continue;
                    }
                    int pos = name.lastIndexOf(47);
                    if (pos < 0) {
                        baseName = "/";
                        filePattern = name;
                    } else {
                        baseName = name.substring(0, pos + 1);
                        filePattern = name.substring(pos + 1);
                    }
                    if (this.hasWildcards(filePattern)) {
                        this.addEntries(bundle, baseName, filePattern, pathList);
                        continue;
                    }
                    this.addEntry(bundle, name, pathList);
                }
                if (pathList.isEmpty() && blueprintHeaderAnnotation != null && blueprintHeaderAnnotation.trim().equalsIgnoreCase("true")) {
                    LOGGER.debug("Scanning bundle {} for blueprint annotations", (Object)bundle.getSymbolicName());
                    ServiceReference sr = this.context.getServiceReference(BlueprintAnnotationScanner.class.getName());
                    if (sr != null) {
                        BlueprintAnnotationScanner bas = (BlueprintAnnotationScanner)this.context.getService(sr);
                        try {
                            URL url = bas.createBlueprintModel(bundle);
                            if (url != null) {
                                pathList.add(url);
                            }
                        }
                        finally {
                            this.context.ungetService(sr);
                        }
                    }
                }
                if (!pathList.isEmpty()) {
                    LOGGER.debug("Found blueprint application in bundle {} with paths: {}", (Object)bundle.getSymbolicName(), pathList);
                    if (this.isCompatible(bundle)) {
                        return pathList;
                    }
                    LOGGER.info("Bundle {} is not compatible with this blueprint extender", (Object)bundle.getSymbolicName());
                } else {
                    LOGGER.debug("No blueprint application found in bundle {}", (Object)bundle.getSymbolicName());
                }
            }
            catch (Throwable t) {
                if (this.stopping) break block18;
                LOGGER.warn("Error creating blueprint container for bundle " + bundle.getSymbolicName(), t);
                this.eventDispatcher.blueprintEvent(new BlueprintEvent(5, bundle, this.context.getBundle(), t));
            }
        }
        return null;
    }

    private List<Bundle> getBundlesToDestroy() {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : this.containers.keySet()) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += BlueprintExtender.getServiceUsage(reference);
                }
            }
            LOGGER.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
            LOGGER.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : this.containers.keySet()) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (BlueprintExtender.getServiceUsage(reference) == 0 || ref != null && reference.compareTo(ref) >= 0) continue;
                    LOGGER.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
            LOGGER.debug("Selected bundle {} for destroy (lowest ranking service)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref) {
        Bundle[] usingBundles = ref.getUsingBundles();
        return usingBundles != null ? usingBundles.length : 0;
    }

    private ExecutorService getExecutorService(Bundle bundle) {
        if (this.executorServiceFinder != null) {
            return this.executorServiceFinder.find(bundle);
        }
        return this.executors;
    }

    private boolean isCompatible(Bundle bundle) {
        boolean compatible;
        if (bundle.getState() == 32) {
            try {
                Class clazz = bundle.getBundleContext().getBundle().loadClass(BlueprintContainer.class.getName());
                compatible = clazz == BlueprintContainer.class;
            }
            catch (ClassNotFoundException e) {
                compatible = true;
            }
        } else {
            compatible = true;
        }
        return compatible;
    }

    private boolean hasWildcards(String path) {
        return path.indexOf("*") >= 0;
    }

    private String getFilePart(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    private String cachePath(Bundle bundle, String filePath) {
        return Integer.toHexString(bundle.hashCode()) + "/" + filePath;
    }

    private URL getOverrideURLForCachePath(String privatePath) {
        URL override = null;
        File privateDataVersion = this.context.getDataFile(privatePath);
        if (privateDataVersion != null && privateDataVersion.exists()) {
            try {
                override = privateDataVersion.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error("Unexpected URL Conversion Issue", (Throwable)e);
            }
        }
        return override;
    }

    private URL getOverrideURL(Bundle bundle, String path) {
        String cachePath = this.cachePath(bundle, path);
        return this.getOverrideURLForCachePath(cachePath);
    }

    private URL getOverrideURL(Bundle bundle, URL path, String basePath) {
        String cachePath = this.cachePath(bundle, basePath + this.getFilePart(path));
        return this.getOverrideURLForCachePath(cachePath);
    }

    private void addEntry(Bundle bundle, String path, List<Object> pathList) {
        URL override = this.getOverrideURL(bundle, path);
        if (override == null) {
            pathList.add(path);
        } else {
            pathList.add(override);
        }
    }

    private void addEntries(Bundle bundle, String path, String filePattern, List<Object> pathList) {
        Enumeration e = bundle.findEntries(path, filePattern, false);
        while (e != null && e.hasMoreElements()) {
            URL u = (URL)e.nextElement();
            URL override = this.getOverrideURL(bundle, u, path);
            if (override == null) {
                pathList.add(u);
                continue;
            }
            pathList.add(override);
        }
    }

    protected BlueprintContainerImpl getBlueprintContainerImpl(Bundle bundle) {
        return (BlueprintContainerImpl)this.containers.get(bundle);
    }

    class FelixExecutorServiceFinder
    implements ExecutorServiceFinder {
        ServiceReference sr;

        FelixExecutorServiceFinder() {
            this.sr = BlueprintExtender.this.context.getServiceReference(MonitoringService.class.getName());
            if (this.sr == null) {
                throw new UnsupportedOperationException();
            }
        }

        public ExecutorService find(Bundle bundle) {
            return ((MonitoringService)BlueprintExtender.this.context.getService(this.sr)).getExecutor(bundle);
        }
    }

    static interface ExecutorServiceFinder {
        public ExecutorService find(Bundle var1);
    }
}

