/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.JMXThreadFactory;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.codec.BundleData;
import org.apache.aries.jmx.codec.BundleEventData;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleState
extends NotificationBroadcasterSupport
implements BundleStateMBean,
MBeanRegistration {
    protected Logger logger;
    protected BundleContext bundleContext;
    protected PackageAdmin packageAdmin;
    protected StartLevel startLevel;
    protected ExecutorService eventDispatcher;
    protected BundleListener bundleListener;
    private AtomicInteger notificationSequenceNumber = new AtomicInteger(1);
    private AtomicInteger attributeChangeNotificationSequenceNumber = new AtomicInteger(1);
    private Lock lock = new ReentrantLock();
    private AtomicInteger registrations = new AtomicInteger(0);
    public static String BUNDLE_EVENT = "org.osgi.bundle.event";

    public BundleState(BundleContext bundleContext, PackageAdmin packageAdmin, StartLevel startLevel, Logger logger) {
        this.bundleContext = bundleContext;
        this.packageAdmin = packageAdmin;
        this.startLevel = startLevel;
        this.logger = logger;
    }

    public String[] getExportedPackages(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getBundleExportedPackages(bundle, this.packageAdmin);
    }

    public long[] getFragments(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getFragmentIds(bundle, this.packageAdmin);
    }

    public TabularData getHeaders(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        Dictionary bundleHeaders = bundle.getHeaders();
        return this.getHeaders(bundleHeaders);
    }

    public TabularData getHeaders(long bundleId, String locale) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        Dictionary bundleHeaders = bundle.getHeaders(locale);
        return this.getHeaders(bundleHeaders);
    }

    private TabularData getHeaders(Dictionary<String, String> bundleHeaders) {
        ArrayList<BundleData.Header> headers = new ArrayList<BundleData.Header>();
        Enumeration<String> keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            headers.add(new BundleData.Header(key, bundleHeaders.get(key)));
        }
        TabularDataSupport headerTable = new TabularDataSupport(HEADERS_TYPE);
        for (BundleData.Header header : headers) {
            headerTable.put(header.toCompositeData());
        }
        return headerTable;
    }

    public String getHeader(long bundleId, String key) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return (String)bundle.getHeaders().get(key);
    }

    public String getHeader(long bundleId, String key, String locale) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return (String)bundle.getHeaders(locale).get(key);
    }

    public long[] getHosts(long fragmentId) throws IOException, IllegalArgumentException {
        Bundle fragment = FrameworkUtils.resolveBundle(this.bundleContext, fragmentId);
        return FrameworkUtils.getHostIds(fragment, this.packageAdmin);
    }

    public String[] getImportedPackages(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getBundleImportedPackages(this.bundleContext, bundle, this.packageAdmin);
    }

    public long getLastModified(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getLastModified();
    }

    public String getLocation(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getLocation();
    }

    public long[] getRegisteredServices(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getRegisteredServiceIds(bundle);
    }

    public long[] getRequiredBundles(long bundleIdentifier) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleIdentifier);
        return FrameworkUtils.getBundleDependencies(this.bundleContext, bundle, this.packageAdmin);
    }

    public long[] getRequiringBundles(long bundleIdentifier) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleIdentifier);
        return FrameworkUtils.getDependentBundles(bundle, this.packageAdmin);
    }

    public long[] getServicesInUse(long bundleIdentifier) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleIdentifier);
        return FrameworkUtils.getServicesInUseByBundle(bundle);
    }

    public int getStartLevel(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return this.startLevel.getBundleStartLevel(bundle);
    }

    public String getState(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getBundleState(bundle);
    }

    public String getSymbolicName(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getSymbolicName();
    }

    public String getVersion(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getVersion().toString();
    }

    public boolean isFragment(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return 1 == this.packageAdmin.getBundleType(bundle);
    }

    public boolean isActivationPolicyUsed(long bundleId) throws IOException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return this.startLevel.isBundleActivationPolicyUsed(bundle);
    }

    public boolean isPersistentlyStarted(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return this.startLevel.isBundlePersistentlyStarted(bundle);
    }

    public boolean isRemovalPending(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.isBundlePendingRemoval(bundle, this.packageAdmin);
    }

    public boolean isRequired(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.isBundleRequiredByOthers(bundle, this.packageAdmin);
    }

    public CompositeData getBundle(long id) throws IOException {
        Bundle bundle = this.bundleContext.getBundle(id);
        if (bundle == null) {
            return null;
        }
        BundleData data = new BundleData(this.bundleContext, bundle, this.packageAdmin, this.startLevel);
        return data.toCompositeData();
    }

    public long[] getBundleIds() throws IOException {
        Bundle[] bundles = this.bundleContext.getBundles();
        long[] ids = new long[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            ids[i] = bundles[i].getBundleId();
        }
        Arrays.sort(ids);
        return ids;
    }

    public TabularData listBundles() throws IOException {
        return this.listBundles(BundleStateMBean.BUNDLE_TYPE.keySet());
    }

    public TabularData listBundles(String ... items) throws IOException {
        return this.listBundles(Arrays.asList(items));
    }

    private TabularData listBundles(Collection<String> items) throws IOException {
        Bundle[] containerBundles = this.bundleContext.getBundles();
        ArrayList<BundleData> bundleDatas = new ArrayList<BundleData>();
        if (containerBundles != null) {
            for (Bundle containerBundle : containerBundles) {
                bundleDatas.add(new BundleData(this.bundleContext, containerBundle, this.packageAdmin, this.startLevel));
            }
        }
        TabularDataSupport bundleTable = new TabularDataSupport(BUNDLES_TYPE);
        for (BundleData bundleData : bundleDatas) {
            bundleTable.put(bundleData.toCompositeData(items));
        }
        return bundleTable;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo eventInfo = new MBeanNotificationInfo(new String[]{BUNDLE_EVENT}, Notification.class.getName(), "A BundleEvent issued from the Framework describing a bundle lifecycle change");
        MBeanNotificationInfo attributeChangeInfo = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "An attribute of this MBean has changed");
        return new MBeanNotificationInfo[]{eventInfo, attributeChangeInfo};
    }

    @Override
    public void postDeregister() {
        if (this.registrations.decrementAndGet() < 1) {
            this.shutDownDispatcher();
        }
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && this.registrations.incrementAndGet() == 1) {
            this.eventDispatcher = Executors.newSingleThreadExecutor(new JMXThreadFactory("JMX OSGi Bundle State Event Dispatcher"));
            this.bundleContext.addBundleListener(this.bundleListener);
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.lock.lock();
        try {
            if (this.bundleListener == null) {
                this.bundleListener = new BundleListener(){

                    public void bundleChanged(BundleEvent event) {
                        try {
                            final Notification notification = new Notification("BundleEvent", "osgi.core:type=bundleState,version=1.7", BundleState.this.notificationSequenceNumber.getAndIncrement());
                            notification.setUserData(new BundleEventData(event).toCompositeData());
                            final AttributeChangeNotification attributeChangeNotification = BundleState.this.getAttributeChangeNotification(event);
                            BundleState.this.eventDispatcher.submit(new Runnable(){

                                public void run() {
                                    BundleState.this.sendNotification(notification);
                                    if (attributeChangeNotification != null) {
                                        BundleState.this.sendNotification(attributeChangeNotification);
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            BundleState.this.logger.log(2, "Task rejected for JMX Notification dispatch of event [" + event + "] - Dispatcher may have been shutdown");
                        }
                        catch (Exception e) {
                            BundleState.this.logger.log(2, "Exception occured on JMX Notification dispatch for event [" + event + "]", e);
                        }
                    }
                };
            }
        }
        finally {
            this.lock.unlock();
        }
        return name;
    }

    protected AttributeChangeNotification getAttributeChangeNotification(BundleEvent event) throws IOException {
        int eventType = event.getType();
        switch (eventType) {
            case 1: 
            case 16: {
                long bundleID = event.getBundle().getBundleId();
                long[] ids = this.getBundleIds();
                ArrayList<Long> without = new ArrayList<Long>();
                for (long id : ids) {
                    if (id == bundleID) continue;
                    without.add(id);
                }
                ArrayList<Long> with = new ArrayList<Long>(without);
                with.add(bundleID);
                Collections.sort(with);
                ArrayList<Long> oldList = eventType == 1 ? without : with;
                ArrayList<Long> newList = eventType == 1 ? with : without;
                long[] oldIDs = new long[oldList.size()];
                for (int i = 0; i < oldIDs.length; ++i) {
                    oldIDs[i] = (Long)oldList.get(i);
                }
                long[] newIDs = new long[newList.size()];
                for (int i = 0; i < newIDs.length; ++i) {
                    newIDs[i] = (Long)newList.get(i);
                }
                return new AttributeChangeNotification("osgi.core:type=bundleState,version=1.7", this.attributeChangeNotificationSequenceNumber.getAndIncrement(), System.currentTimeMillis(), "BundleIds changed", "BundleIds", "Array of long", oldIDs, newIDs);
            }
        }
        return null;
    }

    protected void shutDownDispatcher() {
        if (this.bundleListener != null) {
            try {
                this.bundleContext.removeBundleListener(this.bundleListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.shutdown();
        }
    }

    protected ExecutorService getEventDispatcher() {
        return this.eventDispatcher;
    }
}

