/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.DelayedStarted;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.fusesource.jansi.AnsiConsole;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleFactory {
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private BundleContext bundleContext;
    private CommandProcessor commandProcessor;
    private ThreadIO threadIO;
    private TerminalFactory terminalFactory;
    Console console;
    private boolean start;
    private ServiceRegistration registration;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setThreadIO(ThreadIO threadIO) {
        this.threadIO = threadIO;
    }

    public void registerCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.stop();
        this.start(commandProcessor);
    }

    public void unregisterCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.stop();
    }

    public void setTerminalFactory(TerminalFactory terminalFactory) {
        this.terminalFactory = terminalFactory;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    protected void start(final CommandProcessor commandProcessor) throws Exception {
        if (this.start) {
            Subject subject = new Subject();
            String user = "karaf";
            subject.getPrincipals().add((Principal)new UserPrincipal("karaf"));
            JaasHelper.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConsoleFactory.this.doStart("karaf", commandProcessor);
                    return null;
                }
            });
        }
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) throws Exception {
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            methods[i].setAccessible(true);
            return methods[i].invoke(o, params);
        }
        return null;
    }

    private static <T> T unwrapBIS(T stream) {
        try {
            return (T)ConsoleFactory.invokePrivateMethod(stream, "getInIfOpen", null);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(String user, CommandProcessor commandProcessor) throws Exception {
        Object key;
        final Terminal terminal = this.terminalFactory.getTerminal();
        InputStream unwrappedIn = ConsoleFactory.unwrapBIS(ConsoleFactory.unwrap(System.in));
        InputStream in = terminal.wrapInIfNeeded(unwrappedIn);
        PrintStream out = ConsoleFactory.unwrap(System.out);
        PrintStream err = ConsoleFactory.unwrap(System.err);
        Runnable callback = new Runnable(){

            public void run() {
                try {
                    ConsoleFactory.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        String ctype = System.getenv("LC_CTYPE");
        String encoding = ctype;
        encoding = encoding != null && encoding.indexOf(46) > 0 ? encoding.substring(encoding.indexOf(46) + 1) : System.getProperty("input.encoding", Charset.defaultCharset().name());
        Console console = new Console(commandProcessor, this.threadIO, in, ConsoleFactory.wrap(out), ConsoleFactory.wrap(err), terminal, encoding, callback);
        CommandSession session = console.getSession();
        for (Object o : System.getProperties().keySet()) {
            key = o.toString();
            session.put((String)key, (Object)System.getProperty((String)key));
        }
        session.put("USER", (Object)user);
        session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
        session.put("#LINES", (Object)new Function(){

            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getHeight());
            }
        });
        session.put("#COLUMNS", (Object)new Function(){

            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getWidth());
            }
        });
        if (ctype != null) {
            session.put("LC_CTYPE", (Object)ctype);
        }
        session.put(".jline.terminal", (Object)terminal);
        ServiceRegistration registration = this.bundleContext.registerService(CommandSession.class, (Object)session, null);
        boolean used = false;
        key = this;
        synchronized (key) {
            if (this.console == null) {
                this.console = console;
                this.registration = registration;
                used = true;
            }
        }
        if (used) {
            boolean delayconsole = Boolean.parseBoolean(System.getProperty("karaf.delay.console"));
            if (delayconsole) {
                new DelayedStarted(console, this.bundleContext, unwrappedIn).start();
            } else {
                new Thread((Runnable)console, "Karaf Shell Console Thread").start();
            }
        } else {
            registration.unregister();
            console.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws Exception {
        Console cns;
        ServiceRegistration reg;
        ConsoleFactory consoleFactory = this;
        synchronized (consoleFactory) {
            reg = this.registration;
            this.registration = null;
            cns = this.console;
            this.console = null;
        }
        if (reg != null) {
            reg.unregister();
        }
        if (cns != null) {
            cns.close(false);
        }
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }
}

