/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Nio2Service
implements IoService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FactoryManager manager;
    protected final IoHandler handler;
    protected final ExecutorService executor;
    protected final AsynchronousChannelGroup group;
    protected final Map<Long, IoSession> sessions;
    protected final AtomicBoolean disposing = new AtomicBoolean();

    protected Nio2Service(FactoryManager manager, IoHandler handler) {
        this.logger.debug("Creating {}", (Object)this.getClass().getSimpleName());
        try {
            this.manager = manager;
            this.handler = handler;
            this.executor = Executors.newFixedThreadPool(this.getNioWorkers());
            this.group = AsynchronousChannelGroup.withThreadPool(this.executor);
            this.sessions = new ConcurrentHashMap<Long, IoSession>();
        }
        catch (IOException e) {
            throw new RuntimeSshException(e);
        }
    }

    public int getNioWorkers() {
        int nb;
        String nioWorkers = this.manager.getProperties().get("nio-workers");
        if (nioWorkers != null && nioWorkers.length() > 0 && (nb = Integer.parseInt(nioWorkers)) > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }

    @Override
    public void dispose() {
        if (this.disposing.compareAndSet(false, true)) {
            this.logger.debug("Disposing {}", (Object)this.getClass().getSimpleName());
            this.doDispose();
        }
    }

    protected void doDispose() {
        for (IoSession session : this.sessions.values()) {
            session.close(true);
        }
        this.group.shutdown();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public void sessionClosed(Nio2Session session) {
        this.sessions.remove(session.getId());
    }
}

