/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.impl;

import java.io.IOException;
import java.util.Collection;
import javax.management.openmbean.CompositeData;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPMetadata;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;

public class BlueprintMetadata
implements BlueprintMetadataMBean {
    BundleContext bundleContext;

    public BlueprintMetadata(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public long getBlueprintContainerServiceId(long bundleId) throws IOException {
        Bundle bpBundle = this.bundleContext.getBundle(bundleId);
        if (null == bpBundle) {
            throw new IllegalArgumentException("Invalid bundle id " + bundleId);
        }
        String filter = "(&(osgi.blueprint.container.symbolicname=" + bpBundle.getSymbolicName() + ")(osgi.blueprint.container.version=" + bpBundle.getVersion() + "))";
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = this.bundleContext.getServiceReferences(BlueprintContainer.class.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (serviceReferences == null || serviceReferences.length < 1) {
            return -1L;
        }
        return (Long)serviceReferences[0].getProperty("service.id");
    }

    public long[] getBlueprintContainerServiceIds() throws IOException {
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = this.bundleContext.getServiceReferences(BlueprintContainer.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (serviceReferences == null || serviceReferences.length < 1) {
            return null;
        }
        long[] serviceIds = new long[serviceReferences.length];
        for (int i = 0; i < serviceReferences.length; ++i) {
            serviceIds[i] = (Long)serviceReferences[i].getProperty("service.id");
        }
        return serviceIds;
    }

    public String[] getComponentIds(long containerServiceId) {
        BlueprintContainer container = this.getBlueprintContainer(containerServiceId);
        return container.getComponentIds().toArray(new String[0]);
    }

    public String[] getComponentIdsByType(long containerServiceId, String type) {
        Collection components;
        BlueprintContainer container = this.getBlueprintContainer(containerServiceId);
        if (type.equals("ServiceMetadata")) {
            components = container.getMetadata(ServiceMetadata.class);
        } else if (type.equals("BeanMetadata")) {
            components = container.getMetadata(BeanMetadata.class);
        } else if (type.equals("ServiceReferenceMetadata")) {
            components = container.getMetadata(ServiceReferenceMetadata.class);
        } else {
            throw new IllegalArgumentException("Unrecognized component type: " + type);
        }
        String[] ids = new String[components.size()];
        int i = 0;
        for (ComponentMetadata component : components) {
            if (null == component) continue;
            ids[i++] = component.getId();
        }
        return ids;
    }

    public CompositeData getComponentMetadata(long containerServiceId, String componentId) {
        BlueprintContainer container = this.getBlueprintContainer(containerServiceId);
        ComponentMetadata componentMetadata = container.getComponentMetadata(componentId);
        BPMetadata metadata = Util.metadata2BPMetadata((Metadata)componentMetadata);
        return metadata.asCompositeData();
    }

    private BlueprintContainer getBlueprintContainer(long containerServiceId) {
        String filter = "(service.id=" + containerServiceId + ")";
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = this.bundleContext.getServiceReferences(BlueprintContainer.class.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (serviceReferences == null || serviceReferences.length < 1) {
            throw new IllegalArgumentException("Invalid BlueprintContainer service id: " + containerServiceId);
        }
        return (BlueprintContainer)this.bundleContext.getService(serviceReferences[0]);
    }
}

