/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.File;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NativeFileSystemView;
import org.apache.sshd.common.file.nativefs.NativeSshFile;

public class KarafFileSystemView
extends NativeFileSystemView {
    private String username;
    private String location;

    public KarafFileSystemView(String username) {
        super(username);
        this.username = username;
    }

    public String getVirtualUserDir() {
        return "/";
    }

    public String getPhysicalUserDir() {
        if (this.location == null) {
            this.location = new File(System.getProperty("karaf.base")).getAbsolutePath();
        }
        return this.location;
    }

    protected SshFile getFile(String dir, String file) {
        String location = this.getPhysicalUserDir();
        String physicalName = NativeSshFile.getPhysicalName((String)location, (String)dir, (String)file, (boolean)false);
        if (!physicalName.startsWith(location)) {
            throw new IllegalArgumentException("The path is not relative to KARAF_BASE. For security reason, it's not allowed.");
        }
        File fileObj = new File(physicalName);
        String karafFileName = physicalName.substring(location.length());
        return this.createNativeSshFile(karafFileName, fileObj, this.username);
    }
}

