/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.manifest;

import java.util.ArrayList;
import org.apache.felix.utils.manifest.Parser;
import org.osgi.framework.Version;

public class Attribute {
    private final String name;
    private final String value;
    private final String type;

    public Attribute(String name, String value) {
        this(name, value, null);
    }

    public Attribute(String name, String value, String type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Object getNormalizedValue() {
        if (this.type == null || this.type.equals("String")) {
            return this.value;
        }
        if (this.type.equals("Double")) {
            return new Double(this.value.trim());
        }
        if (this.type.equals("Version")) {
            return new Version(this.value.trim());
        }
        if (this.type.equals("Long")) {
            return new Long(this.value.trim());
        }
        if (this.type.startsWith("List")) {
            int startIdx = this.type.indexOf(60);
            int endIdx = this.type.indexOf(62);
            if (startIdx > 0 && endIdx <= startIdx || startIdx < 0 && endIdx > 0) {
                throw new IllegalArgumentException("Invalid Provide-Capability attribute list type for '" + this.value + "' : " + this.type);
            }
            String listType = "String";
            if (endIdx > startIdx) {
                listType = this.type.substring(startIdx + 1, endIdx).trim();
            }
            String[] tokens = Parser.parseDelimitedString(this.value, ",", false);
            ArrayList<Object> values = new ArrayList<Object>(tokens.length);
            for (String token : tokens) {
                if (listType.equals("String")) {
                    values.add(token);
                    continue;
                }
                if (listType.equals("Double")) {
                    values.add(new Double(token.trim()));
                    continue;
                }
                if (listType.equals("Version")) {
                    values.add(new Version(token.trim()));
                    continue;
                }
                if (listType.equals("Long")) {
                    values.add(new Long(token.trim()));
                    continue;
                }
                throw new IllegalArgumentException("Unknown Provide-Capability attribute list type for '" + this.name + "' : " + this.type);
            }
            return values;
        }
        throw new IllegalArgumentException("Unknown Provide-Capability attribute type for '" + this.name + "' : " + this.type);
    }
}

