/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.log;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TreeMap;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="log", name="get", description="Shows the currently set log level.")
public class GetLogLevel
extends OsgiCommandSupport {
    @Argument(index=0, name="logger", description="The name of the logger, ALL or ROOT (default)", required=false, multiValued=false)
    String logger;
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    static final String ROOT_LOGGER_PREFIX = "log4j.rootLogger";
    static final String LOGGER_PREFIX = "log4j.logger.";
    static final String ALL_LOGGER = "ALL";
    static final String ROOT_LOGGER = "ROOT";

    protected Object doExecute() throws Exception {
        ConfigurationAdmin cfgAdmin = this.getConfigAdmin();
        Configuration cfg = cfgAdmin.getConfiguration(CONFIGURATION_PID, null);
        Dictionary props = cfg.getProperties();
        if (ROOT_LOGGER.equalsIgnoreCase(this.logger)) {
            this.logger = null;
        }
        if (ALL_LOGGER.equalsIgnoreCase(this.logger)) {
            String root = this.getLevel((String)props.get(ROOT_LOGGER_PREFIX));
            TreeMap<String, String> loggers = new TreeMap<String, String>();
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                if (!prop.startsWith(LOGGER_PREFIX)) continue;
                String val = this.getLevel((String)props.get(prop));
                loggers.put(prop.substring(LOGGER_PREFIX.length()), val);
            }
            System.out.println("ROOT: " + root);
            for (String logger : loggers.keySet()) {
                System.out.println(logger + ": " + (String)loggers.get(logger));
            }
        } else {
            String val;
            String logger = this.logger;
            while (true) {
                String prop = logger == null ? ROOT_LOGGER_PREFIX : LOGGER_PREFIX + logger;
                val = (String)props.get(prop);
                if ((val = this.getLevel(val)) != null || logger == null) break;
                int idx = logger.lastIndexOf(46);
                if (idx < 0) {
                    logger = null;
                    continue;
                }
                logger = logger.substring(0, idx);
            }
            String st = "Level: " + val;
            if (logger != this.logger) {
                st = st + " (inherited from " + (logger != null ? logger : ROOT_LOGGER) + ")";
            }
            System.out.println(st);
        }
        return null;
    }

    protected String getLevel(String prop) {
        if (prop == null) {
            return null;
        }
        String val = prop.trim();
        int idx = val.indexOf(",");
        if (idx == 0) {
            val = null;
        } else if (idx > 0) {
            val = val.substring(0, idx);
        }
        return val;
    }

    protected ConfigurationAdmin getConfigAdmin() {
        return (ConfigurationAdmin)this.getService(ConfigurationAdmin.class);
    }
}

