/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.List;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;

@Command(scope = "features", name = "removeUrl", description = "Removes the given list of repository URLs from the features service")
public class RemoveUrlCommand extends FeaturesCommandSupport {

    @Argument(index = 0, name = "urls", description = "One or more repository URLs separated by whitespaces", required = true, multiValued = true)
    List<String> urls;

    @Option(name = "-u", aliases = { "--uninstall-all"}, description = "Uninstall all features contained in the repository URLs", required = false, multiValued = false)
    boolean uninstall;

    protected void doExecute(FeaturesService admin) throws Exception {
        for (String url : urls) {
            admin.removeRepository(new URI(url), uninstall);
        }
    }
}
