/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;

public class ZipRollingFileAppender
extends RollingFileAppender {
    private static final String ZIP = ".zip";

    public void rollOver() {
        if (this.qw != null) {
            LogLog.debug("rolling over count=" + ((CountingQuietWriter)this.qw).getCount());
        }
        LogLog.debug("maxBackupIndex=" + this.maxBackupIndex);
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(this.fileName + '.' + this.maxBackupIndex + ZIP);
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                file = new File(this.fileName + "." + i + ZIP);
                if (!file.exists()) continue;
                target = new File(this.fileName + '.' + (i + 1) + ZIP);
                LogLog.debug("Renaming file " + file + " to " + target);
                file.renameTo(target);
            }
            target = new File(this.fileName + "." + 1);
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug("Renaming file " + file + " to " + target);
            file.renameTo(target);
            boolean archiveResult = this.archiveFile(target);
            if (archiveResult) {
                target.delete();
            } else {
                LogLog.error("Failed to zip file [" + target.getPath() + "].");
            }
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error("setFile(" + this.fileName + ", false) call failed.", e);
        }
    }

    boolean archiveFile(File logFile) {
        try {
            int bytes;
            FileOutputStream fOut = new FileOutputStream(logFile.getPath() + ZIP);
            ZipOutputStream zOut = new ZipOutputStream(fOut);
            FileInputStream fIn = new FileInputStream(logFile);
            BufferedInputStream bIn = new BufferedInputStream(fIn);
            ZipEntry entry = new ZipEntry(logFile.getCanonicalFile().getName());
            zOut.putNextEntry(entry);
            byte[] barray = new byte[1024];
            while ((bytes = bIn.read(barray, 0, 1024)) > -1) {
                zOut.write(barray, 0, bytes);
            }
            zOut.flush();
            zOut.close();
            fOut.close();
            return true;
        }
        catch (IOException ioE) {
            return false;
        }
    }
}

