/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import jline.console.history.FileHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KarafFileHistory
extends FileHistory {
    static final Logger LOGGER = LoggerFactory.getLogger(KarafFileHistory.class);
    boolean failed = false;
    boolean loading = false;

    public KarafFileHistory(File file) throws IOException {
        super(file);
    }

    public void add(CharSequence item) {
        if (!this.loading) {
            item = item.toString().replaceAll("\\!", "\\\\!");
        }
        super.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader reader) throws IOException {
        this.loading = true;
        try {
            super.load(reader);
        }
        finally {
            this.loading = false;
        }
    }

    public void flush() throws IOException {
        if (!this.failed) {
            try {
                super.flush();
            }
            catch (IOException e) {
                this.failed = true;
                LOGGER.debug("Could not write history file: " + this.getFile(), (Throwable)e);
            }
        }
    }

    public void purge() throws IOException {
        if (!this.failed) {
            try {
                super.purge();
            }
            catch (IOException e) {
                this.failed = true;
                LOGGER.debug("Could not delete history file: " + this.getFile(), (Throwable)e);
            }
        }
    }
}

