/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.ClientSession;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAuthPublicKey
implements UserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClientSession session;
    private String service;
    private SshAgent agent;
    private Iterator<PublicKeyIdentity> keys;
    private PublicKeyIdentity current;

    @Override
    public void init(ClientSession session, String service, List<Object> identities) throws Exception {
        KeyPairProvider provider;
        this.session = session;
        this.service = service;
        ArrayList<PublicKeyIdentity> ids = new ArrayList<PublicKeyIdentity>();
        for (Object o : identities) {
            if (!(o instanceof KeyPair)) continue;
            ids.add(new KeyPairIdentity(session.getFactoryManager(), (KeyPair)o));
        }
        SshAgentFactory factory = session.getFactoryManager().getAgentFactory();
        if (factory != null) {
            this.agent = factory.createClient(session.getFactoryManager());
            for (SshAgent.Pair<PublicKey, String> pair : this.agent.getIdentities()) {
                ids.add(new KeyAgentIdentity(this.agent, pair.getFirst()));
            }
        } else {
            this.agent = null;
        }
        if ((provider = session.getFactoryManager().getKeyPairProvider()) != null) {
            for (KeyPair pair : provider.loadKeys()) {
                ids.add(new KeyPairIdentity(session.getFactoryManager(), pair));
            }
        }
        this.keys = ids.iterator();
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        if (buffer == null) {
            if (this.keys.hasNext()) {
                this.current = this.keys.next();
                PublicKey key = this.current.getPublicKey();
                String algo = KeyUtils.getKeyType(key);
                this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for publickey");
                buffer = this.session.createBuffer((byte)50);
                buffer.putString(this.session.getUsername());
                buffer.putString(this.service);
                buffer.putString("publickey");
                buffer.putByte((byte)0);
                buffer.putString(algo);
                buffer.putPublicKey(key);
                this.session.writePacket(buffer);
                return true;
            }
            return false;
        }
        byte cmd = buffer.getByte();
        if (cmd == 60) {
            PublicKey key = this.current.getPublicKey();
            String algo = KeyUtils.getKeyType(key);
            this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for publickey");
            buffer = this.session.createBuffer((byte)50);
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("publickey");
            buffer.putByte((byte)1);
            buffer.putString(algo);
            buffer.putPublicKey(key);
            Buffer bs = new Buffer();
            bs.putString(((AbstractSession)((Object)this.session)).getKex().getH());
            bs.putByte((byte)50);
            bs.putString(this.session.getUsername());
            bs.putString(this.service);
            bs.putString("publickey");
            bs.putByte((byte)1);
            bs.putString(algo);
            bs.putPublicKey(key);
            byte[] sig = this.current.sign(bs.getCompactData());
            bs = new Buffer();
            bs.putString(algo);
            bs.putBytes(sig);
            buffer.putBytes(bs.array(), bs.rpos(), bs.available());
            this.session.writePacket(buffer);
            return true;
        }
        throw new IllegalStateException("Received unknown packet");
    }

    @Override
    public void destroy() {
        if (this.agent != null) {
            this.agent.close();
        }
    }

    static class KeyPairIdentity
    implements PublicKeyIdentity {
        private final KeyPair pair;
        private final FactoryManager manager;

        KeyPairIdentity(FactoryManager manager, KeyPair pair) {
            this.manager = manager;
            this.pair = pair;
        }

        public PublicKey getPublicKey() {
            return this.pair.getPublic();
        }

        public byte[] sign(byte[] data) throws Exception {
            Signature verif = (Signature)NamedFactory.Utils.create(this.manager.getSignatureFactories(), KeyUtils.getKeyType(this.pair));
            verif.init(this.pair.getPublic(), this.pair.getPrivate());
            verif.update(data, 0, data.length);
            return verif.sign();
        }
    }

    static class KeyAgentIdentity
    implements PublicKeyIdentity {
        private final SshAgent agent;
        private final PublicKey key;

        KeyAgentIdentity(SshAgent agent, PublicKey key) {
            this.agent = agent;
            this.key = key;
        }

        public PublicKey getPublicKey() {
            return this.key;
        }

        public byte[] sign(byte[] data) throws Exception {
            return this.agent.sign(this.key, data);
        }
    }

    static interface PublicKeyIdentity {
        public PublicKey getPublicKey();

        public byte[] sign(byte[] var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "publickey";
        }

        @Override
        public UserAuth create() {
            return new UserAuthPublicKey();
        }
    }
}

