/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.common.io.mina.MinaSupport;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MinaService
implements IoService,
org.apache.mina.core.service.IoHandler,
Closeable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final FactoryManager manager;
    protected final IoHandler handler;
    protected final IoProcessor<NioSession> ioProcessor;

    public MinaService(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        this.manager = manager;
        this.handler = handler;
        this.ioProcessor = ioProcessor;
    }

    protected abstract org.apache.mina.core.service.IoService getIoService();

    @Override
    public void dispose() {
        this.getIoService().dispose();
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.dispose();
        return CloseableUtils.closed();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        HashMap mina = new HashMap(this.getIoService().getManagedSessions());
        HashMap<Long, IoSession> sessions = new HashMap<Long, IoSession>();
        for (Long id : mina.keySet()) {
            IoSession session = this.getSession((org.apache.mina.core.session.IoSession)mina.get(id));
            if (session == null) continue;
            sessions.put(id, session);
        }
        return sessions;
    }

    public void sessionCreated(org.apache.mina.core.session.IoSession session) throws Exception {
        MinaSession ioSession = new MinaSession(this, session);
        session.setAttribute(IoSession.class, (Object)ioSession);
        this.handler.sessionCreated(ioSession);
    }

    public void sessionOpened(org.apache.mina.core.session.IoSession session) throws Exception {
    }

    public void sessionClosed(org.apache.mina.core.session.IoSession session) throws Exception {
        this.handler.sessionClosed(this.getSession(session));
    }

    public void sessionIdle(org.apache.mina.core.session.IoSession session, IdleStatus status) throws Exception {
    }

    public void exceptionCaught(org.apache.mina.core.session.IoSession session, Throwable cause) throws Exception {
        this.handler.exceptionCaught(this.getSession(session), cause);
    }

    public void messageReceived(org.apache.mina.core.session.IoSession session, Object message) throws Exception {
        this.handler.messageReceived(this.getSession(session), MinaSupport.asReadable((IoBuffer)message));
    }

    public void messageSent(org.apache.mina.core.session.IoSession session, Object message) throws Exception {
    }

    protected IoSession getSession(org.apache.mina.core.session.IoSession session) {
        return (IoSession)session.getAttribute(IoSession.class);
    }
}

